/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.wrapper;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.plugins.StartScriptGenerator;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.DistributionLocator;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;
import org.gradle.util.GradleVersion;
import org.gradle.util.WrapUtil;
import org.gradle.wrapper.GradleWrapperMain;

public class Wrapper
extends DefaultTask {
    public static final String DEFAULT_DISTRIBUTION_PARENT_NAME = "wrapper/dists";
    private String distributionUrl;
    private Object scriptFile = "gradlew";
    private Object jarFile = "gradle/wrapper/gradle-wrapper.jar";
    @Input
    private String distributionPath = "wrapper/dists";
    @Input
    private PathBase distributionBase = PathBase.GRADLE_USER_HOME;
    private GradleVersion gradleVersion;
    @Input
    private String archivePath = "wrapper/dists";
    @Input
    private PathBase archiveBase = PathBase.GRADLE_USER_HOME;
    private final DistributionLocator locator = new DistributionLocator();

    public Wrapper() {
        this.gradleVersion = GradleVersion.current();
    }

    @Inject
    protected FileLookup getFileLookup() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    void generate() {
        File jarFileDestination = this.getJarFile();
        File unixScript = this.getScriptFile();
        FileResolver resolver = this.getFileLookup().getFileResolver(unixScript.getParentFile());
        String jarFileRelativePath = resolver.resolveAsRelativePath((Object)jarFileDestination);
        this.writeProperties(this.getPropertiesFile());
        URL jarFileSource = Wrapper.class.getResource("/gradle-wrapper.jar");
        if (jarFileSource == null) {
            throw new GradleException("Cannot locate wrapper JAR resource.");
        }
        GFileUtils.copyURLToFile((URL)jarFileSource, (File)jarFileDestination);
        StartScriptGenerator generator = new StartScriptGenerator();
        generator.setApplicationName("Gradle");
        generator.setMainClassName(GradleWrapperMain.class.getName());
        generator.setClasspath((Iterable)WrapUtil.toList((Object[])new String[]{jarFileRelativePath}));
        generator.setOptsEnvironmentVar("GRADLE_OPTS");
        generator.setExitEnvironmentVar("GRADLE_EXIT_CONSOLE");
        generator.setAppNameSystemProperty("org.gradle.appname");
        generator.setScriptRelPath(unixScript.getName());
        generator.generateUnixScript(unixScript);
        generator.generateWindowsScript(this.getBatchScript());
    }

    private void writeProperties(File propertiesFileDestination) {
        Properties wrapperProperties = new Properties();
        wrapperProperties.put("distributionUrl", this.getDistributionUrl());
        wrapperProperties.put("distributionBase", this.distributionBase.toString());
        wrapperProperties.put("distributionPath", this.distributionPath);
        wrapperProperties.put("zipStoreBase", this.archiveBase.toString());
        wrapperProperties.put("zipStorePath", this.archivePath);
        GUtil.saveProperties((Properties)wrapperProperties, (File)propertiesFileDestination);
    }

    @OutputFile
    public File getScriptFile() {
        return this.getProject().file(this.scriptFile);
    }

    public void setScriptFile(Object scriptFile) {
        this.scriptFile = scriptFile;
    }

    @OutputFile
    public File getBatchScript() {
        File scriptFile = this.getScriptFile();
        return new File(scriptFile.getParentFile(), scriptFile.getName().replaceFirst("(\\.[^\\.]+)?$", ".bat"));
    }

    @OutputFile
    public File getJarFile() {
        return this.getProject().file(this.jarFile);
    }

    public void setJarFile(Object jarFile) {
        this.jarFile = jarFile;
    }

    @OutputFile
    public File getPropertiesFile() {
        File jarFileDestination = this.getJarFile();
        return new File(jarFileDestination.getParentFile(), jarFileDestination.getName().replaceAll("\\.jar$", ".properties"));
    }

    public String getDistributionPath() {
        return this.distributionPath;
    }

    public void setDistributionPath(String distributionPath) {
        this.distributionPath = distributionPath;
    }

    public String getGradleVersion() {
        return this.gradleVersion.getVersion();
    }

    public void setGradleVersion(String gradleVersion) {
        this.gradleVersion = GradleVersion.version((String)gradleVersion);
    }

    @Input
    public String getDistributionUrl() {
        if (this.distributionUrl != null) {
            return this.distributionUrl;
        }
        if (this.gradleVersion != null) {
            return this.locator.getDistributionFor(this.gradleVersion).toString();
        }
        return null;
    }

    public void setDistributionUrl(String url) {
        this.distributionUrl = url;
    }

    public PathBase getDistributionBase() {
        return this.distributionBase;
    }

    public void setDistributionBase(PathBase distributionBase) {
        this.distributionBase = distributionBase;
    }

    public String getArchivePath() {
        return this.archivePath;
    }

    public void setArchivePath(String archivePath) {
        this.archivePath = archivePath;
    }

    public PathBase getArchiveBase() {
        return this.archiveBase;
    }

    public void setArchiveBase(PathBase archiveBase) {
        this.archiveBase = archiveBase;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PathBase {
        PROJECT,
        GRADLE_USER_HOME;

    }
}

