/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.sftp;

import com.jcraft.jsch.ChannelSftp;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.FilenameUtils;
import org.gradle.internal.Factory;
import org.gradle.internal.resource.PasswordCredentials;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transport.sftp.LockableSftpClient;
import org.gradle.internal.resource.transport.sftp.SftpClientFactory;
import org.gradle.internal.resource.transport.sftp.SftpException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpResourceUploader
implements ExternalResourceUploader {
    private final SftpClientFactory sftpClientFactory;
    private final PasswordCredentials credentials;

    public SftpResourceUploader(SftpClientFactory sftpClientFactory, PasswordCredentials credentials) {
        this.sftpClientFactory = sftpClientFactory;
        this.credentials = credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(Factory<InputStream> sourceFactory, Long contentLength, URI destination) throws IOException {
        LockableSftpClient client = this.sftpClientFactory.createSftpClient(destination, this.credentials);
        try {
            ChannelSftp channel = client.getSftpClient();
            this.ensureParentDirectoryExists(channel, destination);
            InputStream sourceStream = (InputStream)sourceFactory.create();
            try {
                channel.put(sourceStream, destination.getPath());
            }
            finally {
                sourceStream.close();
            }
        }
        catch (com.jcraft.jsch.SftpException e) {
            throw new SftpException(String.format("Could not write to resource '%s'.", destination), e);
        }
        finally {
            this.sftpClientFactory.releaseSftpClient(client);
        }
    }

    private void ensureParentDirectoryExists(ChannelSftp channel, URI uri) {
        String parentPath = FilenameUtils.getFullPathNoEndSeparator((String)uri.getPath());
        if (parentPath.equals("")) {
            return;
        }
        URI parent = uri.resolve(parentPath);
        try {
            channel.lstat(parentPath);
            return;
        }
        catch (com.jcraft.jsch.SftpException e) {
            if (e.id != 2) {
                throw new SftpException(String.format("Could not get resource '%s'.", parent), e);
            }
            this.ensureParentDirectoryExists(channel, parent);
            try {
                channel.mkdir(parentPath);
            }
            catch (com.jcraft.jsch.SftpException e2) {
                throw new SftpException(String.format("Could not create resource '%s'.", parent), e2);
            }
            return;
        }
    }
}

