/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.sftp;

import com.jcraft.jsch.SftpATTRS;
import java.io.IOException;
import java.net.URI;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.PasswordCredentials;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transport.sftp.LockableSftpClient;
import org.gradle.internal.resource.transport.sftp.SftpClientFactory;
import org.gradle.internal.resource.transport.sftp.SftpException;
import org.gradle.internal.resource.transport.sftp.SftpResource;

public class SftpResourceAccessor
implements ExternalResourceAccessor {
    private final SftpClientFactory sftpClientFactory;
    private final PasswordCredentials credentials;

    public SftpResourceAccessor(SftpClientFactory sftpClientFactory, PasswordCredentials credentials) {
        this.sftpClientFactory = sftpClientFactory;
        this.credentials = credentials;
    }

    public ExternalResourceMetaData getMetaData(URI uri) throws IOException {
        LockableSftpClient sftpClient = this.sftpClientFactory.createSftpClient(uri, this.credentials);
        try {
            SftpATTRS attributes = sftpClient.getSftpClient().lstat(uri.getPath());
            ExternalResourceMetaData externalResourceMetaData = attributes != null ? this.toMetaData(uri, attributes) : null;
            return externalResourceMetaData;
        }
        catch (com.jcraft.jsch.SftpException e) {
            if (e.id == 2) {
                ExternalResourceMetaData externalResourceMetaData = null;
                return externalResourceMetaData;
            }
            throw new SftpException(String.format("Could not get resource '%s'.", uri), e);
        }
        finally {
            this.sftpClientFactory.releaseSftpClient(sftpClient);
        }
    }

    private ExternalResourceMetaData toMetaData(URI uri, SftpATTRS attributes) {
        long lastModified = -1L;
        long contentLength = -1L;
        if ((attributes.getFlags() & 8) != 0) {
            lastModified = attributes.getMTime() * 1000;
        }
        if ((attributes.getFlags() & 1) != 0) {
            contentLength = attributes.getSize();
        }
        return new DefaultExternalResourceMetaData(uri, lastModified, contentLength, null, null);
    }

    public ExternalResource getResource(URI location) throws IOException {
        ExternalResourceMetaData metaData = this.getMetaData(location);
        return metaData != null ? new SftpResource(this.sftpClientFactory, metaData, location, this.credentials) : null;
    }

    public HashValue getResourceSha1(URI location) {
        return null;
    }
}

