/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.DefaultLocallyAvailableExternalResource;
import org.gradle.internal.resource.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.DefaultLocallyAvailableResource;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileResourceConnector
implements ExternalResourceLister,
ExternalResourceAccessor,
ExternalResourceUploader {
    public List<String> list(URI parent) throws IOException {
        String[] names;
        File dir = FileResourceConnector.getFile(parent);
        if (dir.exists() && dir.isDirectory() && (names = dir.list()) != null) {
            return Arrays.asList(names);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(Factory<InputStream> source, Long contentLength, URI destination) throws IOException {
        File target = FileResourceConnector.getFile(destination);
        if (!target.canWrite()) {
            target.delete();
        }
        GFileUtils.mkdirs((File)target.getParentFile());
        FileOutputStream fileOutputStream = new FileOutputStream(target);
        try {
            InputStream sourceInputStream = (InputStream)source.create();
            try {
                IOUtils.copyLarge((InputStream)sourceInputStream, (OutputStream)fileOutputStream);
            }
            finally {
                sourceInputStream.close();
            }
        }
        finally {
            fileOutputStream.close();
        }
    }

    public LocallyAvailableExternalResource getResource(URI uri) throws IOException {
        File localFile = FileResourceConnector.getFile(uri);
        if (!localFile.exists()) {
            return null;
        }
        return new DefaultLocallyAvailableExternalResource(uri, (LocallyAvailableResource)new DefaultLocallyAvailableResource(localFile));
    }

    public ExternalResourceMetaData getMetaData(URI location) throws IOException {
        LocallyAvailableExternalResource resource = this.getResource(location);
        return resource == null ? null : resource.getMetaData();
    }

    public HashValue getResourceSha1(URI location) {
        return null;
    }

    private static File getFile(URI uri) {
        return new File(uri);
    }
}

