/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.gradle.api.Nullable;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultExternalResourceCachePolicy;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.ExternalResourceCachePolicy;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.DefaultLocallyAvailableExternalResource;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.LocallyAvailableExternalResource;
import org.gradle.internal.resource.ResourceException;
import org.gradle.internal.resource.cached.CachedExternalResource;
import org.gradle.internal.resource.cached.CachedExternalResourceAdapter;
import org.gradle.internal.resource.cached.CachedExternalResourceIndex;
import org.gradle.internal.resource.local.DefaultLocallyAvailableResource;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceCandidates;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaDataCompare;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.util.BuildCommencedTimeProvider;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheAwareExternalResourceAccessor
implements CacheAwareExternalResourceAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCacheAwareExternalResourceAccessor.class);
    private final ExternalResourceAccessor delegate;
    private final CachedExternalResourceIndex<String> cachedExternalResourceIndex;
    private final BuildCommencedTimeProvider timeProvider;
    private final TemporaryFileProvider temporaryFileProvider;
    private final CacheLockingManager cacheLockingManager;
    private final ExternalResourceCachePolicy externalResourceCachePolicy = new DefaultExternalResourceCachePolicy();

    public DefaultCacheAwareExternalResourceAccessor(ExternalResourceAccessor delegate, CachedExternalResourceIndex<String> cachedExternalResourceIndex, BuildCommencedTimeProvider timeProvider, TemporaryFileProvider temporaryFileProvider, CacheLockingManager cacheLockingManager) {
        this.delegate = delegate;
        this.cachedExternalResourceIndex = cachedExternalResourceIndex;
        this.timeProvider = timeProvider;
        this.temporaryFileProvider = temporaryFileProvider;
        this.cacheLockingManager = cacheLockingManager;
    }

    @Override
    public LocallyAvailableExternalResource getResource(URI location, CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, @Nullable LocallyAvailableResourceCandidates localCandidates) throws IOException {
        boolean hasLocalCandidates;
        boolean isUnchanged;
        LOGGER.debug("Constructing external resource: {}", (Object)location);
        CachedExternalResource cached = this.cachedExternalResourceIndex.lookup(location.toString());
        if (cached == null && (localCandidates == null || localCandidates.isNone())) {
            return this.copyToCache(location, fileStore, this.delegate.getResource(location));
        }
        if (cached != null && !this.externalResourceCachePolicy.mustRefreshExternalResource(this.getAgeMillis(this.timeProvider, cached))) {
            return new DefaultLocallyAvailableExternalResource(location, (LocallyAvailableResource)new DefaultLocallyAvailableResource(cached.getCachedFile()), cached.getExternalResourceMetaData());
        }
        final ExternalResourceMetaData remoteMetaData = this.delegate.getMetaData(location);
        if (remoteMetaData == null) {
            return null;
        }
        if (cached != null && (isUnchanged = ExternalResourceMetaDataCompare.isDefinitelyUnchanged((ExternalResourceMetaData)cached.getExternalResourceMetaData(), (Factory)new Factory<ExternalResourceMetaData>(){

            public ExternalResourceMetaData create() {
                return remoteMetaData;
            }
        }))) {
            LOGGER.info("Cached resource is up-to-date (lastModified: {}). [HTTP: {}]", (Object)cached.getExternalLastModified(), (Object)location);
            return new DefaultLocallyAvailableExternalResource(location, (LocallyAvailableResource)new DefaultLocallyAvailableResource(cached.getCachedFile()), cached.getExternalResourceMetaData());
        }
        boolean bl = hasLocalCandidates = localCandidates != null && !localCandidates.isNone();
        if (hasLocalCandidates) {
            LocallyAvailableResource local;
            HashValue remoteChecksum = remoteMetaData.getSha1();
            if (remoteChecksum == null) {
                remoteChecksum = this.delegate.getResourceSha1(location);
            }
            if (remoteChecksum != null && (local = localCandidates.findByHashValue(remoteChecksum)) != null) {
                LOGGER.info("Found locally available resource with matching checksum: [{}, {}]", (Object)location, (Object)local.getFile());
                return this.copyToCache(location, fileStore, (ExternalResource)new CachedExternalResourceAdapter(location, local, this.delegate, remoteMetaData, remoteChecksum));
            }
        }
        return this.copyToCache(location, fileStore, this.delegate.getResource(location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocallyAvailableExternalResource copyToCache(final URI source, final CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, final ExternalResource resource) {
        if (resource == null) {
            return null;
        }
        final File destination = this.temporaryFileProvider.createTemporaryFile("gradle_download", "bin", new String[0]);
        try {
            try {
                try {
                    LOGGER.debug("Downloading {} to {}", (Object)resource.getName(), (Object)destination);
                    if (destination.getParentFile() != null) {
                        GFileUtils.mkdirs((File)destination.getParentFile());
                    }
                    resource.writeTo(destination);
                }
                finally {
                    resource.close();
                }
            }
            catch (IOException e) {
                throw new ResourceException(String.format("Failed to download resource '%s'.", resource.getName()), (Throwable)e);
            }
            LocallyAvailableExternalResource locallyAvailableExternalResource = (LocallyAvailableExternalResource)this.cacheLockingManager.useCache(String.format("Store %s", resource.getName()), (Factory)new Factory<LocallyAvailableExternalResource>(){

                public LocallyAvailableExternalResource create() {
                    LocallyAvailableResource cachedResource = fileStore.moveIntoCache(destination);
                    File fileInFileStore = cachedResource.getFile();
                    ExternalResourceMetaData metaData = resource.getMetaData();
                    DefaultCacheAwareExternalResourceAccessor.this.cachedExternalResourceIndex.store(source.toString(), fileInFileStore, metaData);
                    return new DefaultLocallyAvailableExternalResource(source, cachedResource, metaData);
                }
            });
            return locallyAvailableExternalResource;
        }
        finally {
            destination.delete();
        }
    }

    public long getAgeMillis(BuildCommencedTimeProvider timeProvider, CachedExternalResource cached) {
        return timeProvider.getCurrentTime() - cached.getCachedAt();
    }
}

