/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import org.gradle.internal.resource.transfer.ResourceOperation;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;

public class AbstractProgressLoggingHandler {
    protected final ProgressLoggerFactory progressLoggerFactory;

    public AbstractProgressLoggingHandler(ProgressLoggerFactory progressLoggerFactory) {
        this.progressLoggerFactory = progressLoggerFactory;
    }

    protected ResourceOperation createResourceOperation(String resourceName, ResourceOperation.Type operationType, Class loggingClazz, long contentLength) {
        ProgressLogger progressLogger = this.startProgress(String.format("%s %s", operationType.getCapitalized(), resourceName), loggingClazz);
        return new ResourceOperation(progressLogger, operationType, contentLength);
    }

    private ProgressLogger startProgress(String description, Class loggingClass) {
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(loggingClass != null ? loggingClass : this.getClass());
        progressLogger.setDescription(description);
        progressLogger.setLoggingHeader(description);
        progressLogger.started();
        return progressLogger;
    }
}

