/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local.ivy;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactMetaData;
import org.gradle.api.internal.artifacts.mvnsettings.CannotLocateLocalMavenRepositoryException;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.internal.artifacts.repositories.resolver.IvyResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.M2ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.local.CompositeLocallyAvailableResourceFinder;
import org.gradle.internal.resource.local.FileStoreSearcher;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceCandidates;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinderSearchableFileStoreAdapter;
import org.gradle.internal.resource.local.ivy.PatternBasedLocallyAvailableResourceFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocallyAvailableResourceFinderFactory
implements Factory<LocallyAvailableResourceFinder<ModuleVersionArtifactMetaData>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocallyAvailableResourceFinderFactory.class);
    private final File rootCachesDirectory;
    private final LocalMavenRepositoryLocator localMavenRepositoryLocator;
    private final FileStoreSearcher<ModuleVersionArtifactMetaData> fileStore;

    public LocallyAvailableResourceFinderFactory(ArtifactCacheMetaData artifactCacheMetaData, LocalMavenRepositoryLocator localMavenRepositoryLocator, FileStoreSearcher<ModuleVersionArtifactMetaData> fileStore) {
        this.rootCachesDirectory = artifactCacheMetaData.getCacheDir().getParentFile();
        this.localMavenRepositoryLocator = localMavenRepositoryLocator;
        this.fileStore = fileStore;
    }

    public LocallyAvailableResourceFinder<ModuleVersionArtifactMetaData> create() {
        LinkedList<LocallyAvailableResourceFinder<ModuleVersionArtifactMetaData>> finders = new LinkedList<LocallyAvailableResourceFinder<ModuleVersionArtifactMetaData>>();
        finders.add((LocallyAvailableResourceFinder<ModuleVersionArtifactMetaData>)new LocallyAvailableResourceFinderSearchableFileStoreAdapter(this.fileStore));
        this.addForPattern(finders, "artifacts-26/filestore/[organisation]/[module](/[branch])/[revision]/[type]/*/[artifact]-[revision](-[classifier])(.[ext])");
        this.addForPattern(finders, "artifacts-24/filestore/[organisation]/[module](/[branch])/[revision]/[type]/*/[artifact]-[revision](-[classifier])(.[ext])");
        this.addForPattern(finders, "artifacts-23/filestore/[organisation]/[module](/[branch])/[revision]/[type]/*/[artifact]-[revision](-[classifier])(.[ext])");
        this.addForPattern(finders, "artifacts-15/filestore/[organisation]/[module](/[branch])/[revision]/[type]/*/[artifact]-[revision](-[classifier])(.[ext])");
        this.addForPattern(finders, "artifacts-14/filestore/[organisation]/[module](/[branch])/[revision]/[type]/*/[artifact]-[revision](-[classifier])(.[ext])");
        this.addForPattern(finders, "artifacts-13/filestore/[organisation]/[module](/[branch])/[revision]/[type]/*/[artifact]-[revision](-[classifier])(.[ext])");
        this.addForPattern(finders, "artifacts-8/filestore/[organisation]/[module](/[branch])/[revision]/[type]/*/[artifact]-[revision](-[classifier])(.[ext])");
        this.addForPattern(finders, "artifacts-7/artifacts/*/[organisation]/[module](/[branch])/[revision]/[type]/[artifact]-[revision](-[classifier])(.[ext])");
        this.addForPattern(finders, "artifacts-4/[organisation]/[module](/[branch])/*/[type]s/[artifact]-[revision](-[classifier])(.[ext])");
        this.addForPattern(finders, "artifacts-4/[organisation]/[module](/[branch])/*/pom.originals/[artifact]-[revision](-[classifier])(.[ext])");
        this.addForPattern(finders, "../cache/[organisation]/[module](/[branch])/[type]s/[artifact]-[revision](-[classifier])(.[ext])");
        try {
            File localMavenRepository = this.localMavenRepositoryLocator.getLocalMavenRepository();
            if (localMavenRepository.exists()) {
                this.addForPattern(finders, localMavenRepository, new M2ResourcePattern("[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier])(.[ext])"));
            }
        }
        catch (CannotLocateLocalMavenRepositoryException ex) {
            finders.add(new NoMavenLocalRepositoryResourceFinder(ex));
        }
        return new CompositeLocallyAvailableResourceFinder(finders);
    }

    private void addForPattern(List<LocallyAvailableResourceFinder<ModuleVersionArtifactMetaData>> finders, String pattern) {
        int wildcardPos = pattern.indexOf("/*/");
        int patternPos = pattern.indexOf("/[");
        if (wildcardPos < 0 && patternPos < 0) {
            throw new IllegalArgumentException(String.format("Unsupported pattern '%s'", pattern));
        }
        int chopAt = wildcardPos >= 0 && patternPos >= 0 ? Math.min(wildcardPos, patternPos) : (wildcardPos >= 0 ? wildcardPos : patternPos);
        String pathPart = pattern.substring(0, chopAt);
        String patternPart = pattern.substring(chopAt + 1);
        this.addForPattern(finders, new File(this.rootCachesDirectory, pathPart), new IvyResourcePattern(patternPart));
    }

    private void addForPattern(List<LocallyAvailableResourceFinder<ModuleVersionArtifactMetaData>> finders, File baseDir, ResourcePattern pattern) {
        if (baseDir.exists()) {
            finders.add((LocallyAvailableResourceFinder<ModuleVersionArtifactMetaData>)new PatternBasedLocallyAvailableResourceFinder(baseDir, pattern));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NoMavenLocalRepositoryResourceFinder
    implements LocallyAvailableResourceFinder<ModuleVersionArtifactMetaData> {
        private final CannotLocateLocalMavenRepositoryException ex;
        private boolean logged;

        public NoMavenLocalRepositoryResourceFinder(CannotLocateLocalMavenRepositoryException ex) {
            this.ex = ex;
        }

        public LocallyAvailableResourceCandidates findCandidates(ModuleVersionArtifactMetaData criterion) {
            if (!this.logged) {
                LOGGER.warn("Unable to locate local Maven repository.");
                LOGGER.debug("Problems while locating local Maven repository.", (Throwable)((Object)this.ex));
                this.logged = true;
            }
            return new LocallyAvailableResourceCandidates(){

                public boolean isNone() {
                    return true;
                }

                public LocallyAvailableResource findByHashValue(HashValue hashValue) {
                    return null;
                }
            };
        }
    }
}

