/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.cached.ivy;

import java.io.File;
import java.math.BigInteger;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactIdentifier;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactIdentifierSerializer;
import org.gradle.internal.resource.cached.CachedArtifact;
import org.gradle.internal.resource.cached.CachedArtifactIndex;
import org.gradle.internal.resource.cached.DefaultCachedArtifact;
import org.gradle.internal.resource.cached.ivy.AbstractCachedIndex;
import org.gradle.internal.resource.cached.ivy.ArtifactAtRepositoryKey;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.Serializer;
import org.gradle.util.BuildCommencedTimeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactAtRepositoryCachedArtifactIndex
extends AbstractCachedIndex<ArtifactAtRepositoryKey, CachedArtifact>
implements CachedArtifactIndex {
    private final BuildCommencedTimeProvider timeProvider;

    public ArtifactAtRepositoryCachedArtifactIndex(String persistentCacheFile, BuildCommencedTimeProvider timeProvider, CacheLockingManager cacheLockingManager) {
        super(persistentCacheFile, new ArtifactAtRepositoryKeySerializer(), new CachedArtifactSerializer(), cacheLockingManager);
        this.timeProvider = timeProvider;
    }

    private DefaultCachedArtifact createEntry(File artifactFile, BigInteger moduleDescriptorHash) {
        return new DefaultCachedArtifact(artifactFile, this.timeProvider.getCurrentTime(), moduleDescriptorHash);
    }

    @Override
    public void store(ArtifactAtRepositoryKey key, File artifactFile, BigInteger moduleDescriptorHash) {
        this.assertArtifactFileNotNull(artifactFile);
        this.assertKeyNotNull(key);
        this.storeInternal(key, this.createEntry(artifactFile, moduleDescriptorHash));
    }

    @Override
    public void storeMissing(ArtifactAtRepositoryKey key, BigInteger descriptorHash) {
        this.storeInternal(key, this.createMissingEntry(descriptorHash));
    }

    CachedArtifact createMissingEntry(BigInteger descriptorHash) {
        return new DefaultCachedArtifact(this.timeProvider.getCurrentTime(), descriptorHash);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedArtifactSerializer
    implements Serializer<CachedArtifact> {
        private CachedArtifactSerializer() {
        }

        public void write(Encoder encoder, CachedArtifact value) throws Exception {
            encoder.writeBoolean(value.isMissing());
            if (!value.isMissing()) {
                encoder.writeString((CharSequence)value.getCachedFile().getPath());
            }
            encoder.writeLong(value.getCachedAt());
            byte[] hash = value.getDescriptorHash().toByteArray();
            encoder.writeBinary(hash);
        }

        public CachedArtifact read(Decoder decoder) throws Exception {
            boolean isMissing = decoder.readBoolean();
            File file = !isMissing ? new File(decoder.readString()) : null;
            long createTimestamp = decoder.readLong();
            byte[] encodedHash = decoder.readBinary();
            BigInteger hash = new BigInteger(encodedHash);
            return new DefaultCachedArtifact(file, createTimestamp, hash);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArtifactAtRepositoryKeySerializer
    implements Serializer<ArtifactAtRepositoryKey> {
        private final Serializer<ModuleVersionArtifactIdentifier> artifactIdSerializer = new ModuleVersionArtifactIdentifierSerializer();

        private ArtifactAtRepositoryKeySerializer() {
        }

        public void write(Encoder encoder, ArtifactAtRepositoryKey value) throws Exception {
            encoder.writeString((CharSequence)value.getRepositoryId());
            this.artifactIdSerializer.write(encoder, (Object)value.getArtifactId());
        }

        public ArtifactAtRepositoryKey read(Decoder decoder) throws Exception {
            String repositoryId = decoder.readString();
            ModuleVersionArtifactIdentifier artifactIdentifier = (ModuleVersionArtifactIdentifier)this.artifactIdSerializer.read(decoder);
            return new ArtifactAtRepositoryKey(repositoryId, artifactIdentifier);
        }
    }
}

