/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.internal.artifacts.dsl.ParsedModuleStringNotation;
import org.gradle.api.internal.artifacts.dsl.dependencies.ModuleFactoryHelper;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyStringNotationParser<T extends ExternalDependency>
implements NotationConverter<String, T> {
    private final Instantiator instantiator;
    private final Class<T> wantedType;
    public static final Pattern EXTENSION_SPLITTER = Pattern.compile("^(.+)\\@([^:]+$)");

    public DependencyStringNotationParser(Instantiator instantiator, Class<T> wantedType) {
        this.instantiator = instantiator;
        this.wantedType = wantedType;
    }

    public void describe(Collection<String> candidateFormats) {
        candidateFormats.add("String or CharSequence values, e.g. 'org.gradle:gradle-core:1.0'.");
    }

    public void convert(String notation, NotationConvertResult<? super T> result) throws TypeConversionException {
        result.converted(this.createDependencyFromString(notation));
    }

    private T createDependencyFromString(String notation) {
        ParsedModuleStringNotation parsedNotation = this.splitModuleFromExtension(notation);
        ExternalDependency moduleDependency = (ExternalDependency)this.instantiator.newInstance(this.wantedType, new Object[]{parsedNotation.getGroup(), parsedNotation.getName(), parsedNotation.getVersion()});
        ModuleFactoryHelper.addExplicitArtifactsIfDefined((ExternalDependency)moduleDependency, (String)parsedNotation.getArtifactType(), (String)parsedNotation.getClassifier());
        return (T)moduleDependency;
    }

    private ParsedModuleStringNotation splitModuleFromExtension(String notation) {
        Matcher matcher = EXTENSION_SPLITTER.matcher(notation);
        boolean hasArtifactType = matcher.matches();
        if (hasArtifactType && !ClientModule.class.isAssignableFrom(this.wantedType)) {
            if (matcher.groupCount() != 2) {
                throw new InvalidUserDataException("The dependency notation " + notation + " is invalid");
            }
            return new ParsedModuleStringNotation(matcher.group(1), matcher.group(2));
        }
        return new ParsedModuleStringNotation(notation, null);
    }
}

