/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResourceAwareResolveResult;
import org.gradle.api.internal.artifacts.metadata.IvyArtifactName;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.VersionLister;
import org.gradle.api.internal.artifacts.repositories.resolver.VersionPatternVisitor;
import org.gradle.internal.resource.ResourceException;
import org.gradle.internal.resource.ResourceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedVersionLister
implements VersionLister {
    private final List<VersionLister> versionListers;

    public ChainedVersionLister(VersionLister ... delegates) {
        this.versionListers = Arrays.asList(delegates);
    }

    @Override
    public VersionPatternVisitor newVisitor(final ModuleIdentifier module, Collection<String> dest, ResourceAwareResolveResult result) {
        final ArrayList<VersionPatternVisitor> visitors = new ArrayList<VersionPatternVisitor>();
        for (VersionLister lister : this.versionListers) {
            visitors.add(lister.newVisitor(module, dest, result));
        }
        return new VersionPatternVisitor(){

            public void visit(ResourcePattern pattern, IvyArtifactName artifact) throws ResourceException {
                ResourceNotFoundException failure = null;
                for (VersionPatternVisitor list : visitors) {
                    try {
                        list.visit(pattern, artifact);
                        return;
                    }
                    catch (ResourceNotFoundException e) {
                        if (failure != null) continue;
                        failure = e;
                    }
                    catch (Exception e) {
                        throw new ResourceException(String.format("Failed to list versions for %s.", module), (Throwable)e);
                    }
                }
                throw failure;
            }
        };
    }
}

