/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.metadata;

import java.util.Map;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.metadata.DefaultModuleVersionArtifactIdentifier;
import org.gradle.api.internal.artifacts.metadata.IvyArtifactName;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactIdentifier;
import org.gradle.messaging.serialize.BaseSerializerFactory;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.MapSerializer;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleVersionArtifactIdentifierSerializer
implements Serializer<ModuleVersionArtifactIdentifier> {
    private final ComponentIdentifierSerializer componentIdentifierSerializer = new ComponentIdentifierSerializer();
    private final MapSerializer<String, String> attributesSerializer = new MapSerializer(BaseSerializerFactory.STRING_SERIALIZER, BaseSerializerFactory.STRING_SERIALIZER);

    public void write(Encoder encoder, ModuleVersionArtifactIdentifier value) throws Exception {
        DefaultModuleVersionArtifactIdentifier artifact = (DefaultModuleVersionArtifactIdentifier)value;
        this.componentIdentifierSerializer.write(encoder, (ComponentIdentifier)artifact.getComponentIdentifier());
        IvyArtifactName ivyArtifactName = artifact.getName();
        encoder.writeString((CharSequence)ivyArtifactName.getName());
        encoder.writeString((CharSequence)ivyArtifactName.getType());
        encoder.writeNullableString((CharSequence)ivyArtifactName.getExtension());
        this.attributesSerializer.write(encoder, ivyArtifactName.getAttributes());
    }

    public ModuleVersionArtifactIdentifier read(Decoder decoder) throws Exception {
        ModuleComponentIdentifier componentIdentifier = (ModuleComponentIdentifier)this.componentIdentifierSerializer.read(decoder);
        String artifactName = decoder.readString();
        String type = decoder.readString();
        String extension = decoder.readNullableString();
        Map attributes = this.attributesSerializer.read(decoder);
        return new DefaultModuleVersionArtifactIdentifier(componentIdentifier, artifactName, type, extension, attributes);
    }
}

