/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.metadata;

import java.util.Collections;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.metadata.DefaultIvyArtifactName;
import org.gradle.api.internal.artifacts.metadata.IvyArtifactName;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModuleVersionArtifactIdentifier
implements ModuleVersionArtifactIdentifier {
    private final ModuleComponentIdentifier componentIdentifier;
    private final IvyArtifactName name;

    public DefaultModuleVersionArtifactIdentifier(ModuleComponentIdentifier componentIdentifier, Artifact artifact) {
        this(componentIdentifier, artifact.getName(), artifact.getType(), artifact.getExt(), artifact.getExtraAttributes());
    }

    public DefaultModuleVersionArtifactIdentifier(ModuleComponentIdentifier componentIdentifier, String name, String type, @Nullable String extension) {
        this(componentIdentifier, name, type, extension, Collections.emptyMap());
    }

    public DefaultModuleVersionArtifactIdentifier(ModuleComponentIdentifier componentIdentifier, String name, String type, @Nullable String extension, Map<String, String> attributes) {
        this(componentIdentifier, new DefaultIvyArtifactName(name, type, extension, attributes));
    }

    public DefaultModuleVersionArtifactIdentifier(ModuleComponentIdentifier componentIdentifier, IvyArtifactName artifact) {
        this.componentIdentifier = componentIdentifier;
        this.name = artifact;
    }

    @Override
    public String getDisplayName() {
        return String.format("%s:%s", this.componentIdentifier, this.name);
    }

    public IvyArtifactName getName() {
        return this.name;
    }

    @Override
    public ModuleComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public int hashCode() {
        return this.componentIdentifier.hashCode() ^ this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultModuleVersionArtifactIdentifier other = (DefaultModuleVersionArtifactIdentifier)obj;
        return other.componentIdentifier.equals(this.componentIdentifier) && other.name.equals(this.name);
    }
}

