/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.metadata;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.component.DefaultModuleComponentSelector;
import org.gradle.api.internal.artifacts.component.DefaultProjectComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.IvyUtil;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ProjectDependencyDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ReflectiveDependencyDescriptorFactory;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ConfigurationMetaData;
import org.gradle.api.internal.artifacts.metadata.DefaultIvyArtifactName;
import org.gradle.api.internal.artifacts.metadata.DependencyMetaData;
import org.gradle.api.internal.artifacts.metadata.IvyArtifactName;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependencyMetaData
implements DependencyMetaData {
    private final DependencyDescriptor dependencyDescriptor;
    private final DefaultModuleVersionSelector requested;

    public DefaultDependencyMetaData(DependencyDescriptor dependencyDescriptor) {
        this.dependencyDescriptor = dependencyDescriptor;
        ModuleRevisionId dependencyRevisionId = dependencyDescriptor.getDependencyRevisionId();
        this.requested = new DefaultModuleVersionSelector(dependencyRevisionId.getOrganisation(), dependencyRevisionId.getName(), dependencyRevisionId.getRevision());
    }

    public DefaultDependencyMetaData(ModuleVersionIdentifier moduleVersionIdentifier) {
        this.dependencyDescriptor = new DefaultDependencyDescriptor(IvyUtil.createModuleRevisionId(moduleVersionIdentifier), false);
        this.requested = new DefaultModuleVersionSelector(moduleVersionIdentifier.getGroup(), moduleVersionIdentifier.getName(), moduleVersionIdentifier.getVersion());
    }

    public DefaultDependencyMetaData(ModuleComponentIdentifier componentIdentifier) {
        this.dependencyDescriptor = new DefaultDependencyDescriptor(IvyUtil.createModuleRevisionId(componentIdentifier), false);
        this.requested = new DefaultModuleVersionSelector(componentIdentifier.getGroup(), componentIdentifier.getModule(), componentIdentifier.getVersion());
    }

    public String toString() {
        return this.dependencyDescriptor.toString();
    }

    @Override
    public ModuleVersionSelector getRequested() {
        return this.requested;
    }

    @Override
    public boolean isChanging() {
        return this.dependencyDescriptor.isChanging();
    }

    @Override
    public boolean isTransitive() {
        return this.dependencyDescriptor.isTransitive();
    }

    @Override
    public DependencyDescriptor getDescriptor() {
        return this.dependencyDescriptor;
    }

    @Override
    public Set<ComponentArtifactMetaData> getArtifacts(ConfigurationMetaData fromConfiguration, ConfigurationMetaData toConfiguration) {
        String[] targetConfigurations = fromConfiguration.getHierarchy().toArray(new String[fromConfiguration.getHierarchy().size()]);
        DependencyArtifactDescriptor[] dependencyArtifacts = this.dependencyDescriptor.getDependencyArtifacts(targetConfigurations);
        if (dependencyArtifacts.length == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet<ComponentArtifactMetaData> artifacts = new LinkedHashSet<ComponentArtifactMetaData>();
        for (DependencyArtifactDescriptor artifactDescriptor : dependencyArtifacts) {
            ModuleRevisionId id = toConfiguration.getComponent().getDescriptor().getModuleRevisionId();
            DefaultArtifact artifact = new DefaultArtifact(id, null, artifactDescriptor.getName(), artifactDescriptor.getType(), artifactDescriptor.getExt(), artifactDescriptor.getUrl(), artifactDescriptor.getQualifiedExtraAttributes());
            artifacts.add(toConfiguration.getComponent().artifact((Artifact)artifact));
        }
        return artifacts;
    }

    @Override
    public Set<IvyArtifactName> getArtifacts() {
        DependencyArtifactDescriptor[] dependencyArtifacts = this.dependencyDescriptor.getAllDependencyArtifacts();
        if (dependencyArtifacts.length == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet artifactSet = Sets.newLinkedHashSet();
        for (DependencyArtifactDescriptor artifact : dependencyArtifacts) {
            artifactSet.add(new DefaultIvyArtifactName(artifact.getName(), artifact.getType(), artifact.getExt(), artifact.getExtraAttributes()));
        }
        return artifactSet;
    }

    @Override
    public DependencyMetaData withRequestedVersion(String requestedVersion) {
        if (requestedVersion.equals(this.requested.getVersion())) {
            return this;
        }
        return new DefaultDependencyMetaData(this.dependencyDescriptor.clone(IvyUtil.createModuleRevisionId(this.dependencyDescriptor.getDependencyRevisionId(), requestedVersion)));
    }

    @Override
    public DependencyMetaData withRequestedVersion(ModuleVersionSelector requestedVersion) {
        if (requestedVersion.equals(this.requested)) {
            return this;
        }
        ModuleRevisionId requestedId = IvyUtil.createModuleRevisionId(requestedVersion.getGroup(), requestedVersion.getName(), requestedVersion.getVersion());
        DependencyDescriptor substitutedDescriptor = new ReflectiveDependencyDescriptorFactory().create(this.dependencyDescriptor, requestedId);
        return new DefaultDependencyMetaData(substitutedDescriptor);
    }

    @Override
    public DependencyMetaData withChanging() {
        if (this.dependencyDescriptor.isChanging()) {
            return this;
        }
        DependencyDescriptor forcedChanging = this.dependencyDescriptor.clone(this.dependencyDescriptor.getDependencyRevisionId());
        try {
            Field field = DefaultDependencyDescriptor.class.getDeclaredField("isChanging");
            field.setAccessible(true);
            field.set(forcedChanging, true);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        return new DefaultDependencyMetaData(forcedChanging);
    }

    @Override
    public ComponentSelector getSelector() {
        if (this.dependencyDescriptor instanceof ProjectDependencyDescriptor) {
            return new DefaultProjectComponentSelector(((ProjectDependencyDescriptor)this.dependencyDescriptor).getTargetProject().getPath());
        }
        return DefaultModuleComponentSelector.newSelector(this.requested.getGroup(), this.requested.getName(), this.requested.getVersion());
    }
}

