/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.metadata;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.component.DefaultModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleSource;
import org.gradle.api.internal.artifacts.metadata.AbstractModuleDescriptorBackedMetaData;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ConfigurationMetaData;
import org.gradle.api.internal.artifacts.metadata.DefaultModuleVersionArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionMetaData;
import org.gradle.api.internal.artifacts.metadata.MutableModuleVersionMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractModuleVersionMetaData
extends AbstractModuleDescriptorBackedMetaData
implements MutableModuleVersionMetaData {
    private Set<ModuleVersionArtifactMetaData> artifacts;
    private Multimap<String, ModuleVersionArtifactMetaData> artifactsByConfig;

    public AbstractModuleVersionMetaData(ModuleDescriptor moduleDescriptor) {
        this(AbstractModuleVersionMetaData.moduleVersionIdentifier(moduleDescriptor), moduleDescriptor, AbstractModuleVersionMetaData.moduleComponentIdentifier(moduleDescriptor));
    }

    private static ModuleVersionIdentifier moduleVersionIdentifier(ModuleDescriptor descriptor) {
        return DefaultModuleVersionIdentifier.newId(descriptor.getModuleRevisionId());
    }

    private static ModuleComponentIdentifier moduleComponentIdentifier(ModuleDescriptor descriptor) {
        return DefaultModuleComponentIdentifier.newId(AbstractModuleVersionMetaData.moduleVersionIdentifier(descriptor));
    }

    public AbstractModuleVersionMetaData(ModuleVersionIdentifier moduleVersionIdentifier, ModuleDescriptor moduleDescriptor, ModuleComponentIdentifier componentIdentifier) {
        super(moduleVersionIdentifier, moduleDescriptor, (ComponentIdentifier)componentIdentifier);
    }

    protected void copyTo(AbstractModuleVersionMetaData copy) {
        super.copyTo(copy);
        copy.artifacts = this.artifacts;
        copy.artifactsByConfig = this.artifactsByConfig;
    }

    @Override
    public abstract AbstractModuleVersionMetaData copy();

    @Override
    public ModuleVersionMetaData withSource(ModuleSource source) {
        AbstractModuleVersionMetaData copy = this.copy();
        copy.setModuleSource(source);
        return copy;
    }

    @Override
    public ModuleComponentIdentifier getComponentId() {
        return (ModuleComponentIdentifier)super.getComponentId();
    }

    @Override
    public ModuleVersionArtifactMetaData artifact(Artifact artifact) {
        return new DefaultModuleVersionArtifactMetaData(this.getComponentId(), artifact);
    }

    @Override
    public ModuleVersionArtifactMetaData artifact(String type, @Nullable String extension, @Nullable String classifier) {
        Map extraAttributes = classifier == null ? Collections.emptyMap() : Collections.singletonMap("m:classifier", classifier);
        DefaultArtifact artifact = new DefaultArtifact(this.getDescriptor().getModuleRevisionId(), null, this.getId().getName(), type, extension, extraAttributes);
        return new DefaultModuleVersionArtifactMetaData(this.getComponentId(), (Artifact)artifact);
    }

    @Override
    public Set<ModuleVersionArtifactMetaData> getArtifacts() {
        if (this.artifacts == null) {
            this.populateArtifactsFromDescriptor();
        }
        return this.artifacts;
    }

    @Override
    public void setArtifacts(Iterable<? extends ModuleVersionArtifactMetaData> artifacts) {
        this.artifacts = Sets.newLinkedHashSet(artifacts);
        this.artifactsByConfig = LinkedHashMultimap.create();
        for (String config : this.getDescriptor().getConfigurationsNames()) {
            this.artifactsByConfig.putAll((Object)config, artifacts);
        }
    }

    @Override
    protected Set<ComponentArtifactMetaData> getArtifactsForConfiguration(ConfigurationMetaData configurationMetaData) {
        if (this.artifactsByConfig == null) {
            this.populateArtifactsFromDescriptor();
        }
        LinkedHashSet<ComponentArtifactMetaData> artifactMetaData = new LinkedHashSet<ComponentArtifactMetaData>();
        for (String ancestor : configurationMetaData.getHierarchy()) {
            artifactMetaData.addAll(this.artifactsByConfig.get((Object)ancestor));
        }
        return artifactMetaData;
    }

    private void populateArtifactsFromDescriptor() {
        LinkedHashMap artifactToMetaData = Maps.newLinkedHashMap();
        for (Artifact artifact : this.getDescriptor().getAllArtifacts()) {
            ModuleVersionArtifactMetaData artifact2 = this.artifact(artifact);
            artifactToMetaData.put(artifact, artifact2);
        }
        this.artifacts = Sets.newLinkedHashSet(artifactToMetaData.values());
        this.artifactsByConfig = LinkedHashMultimap.create();
        for (String string : this.getDescriptor().getConfigurationsNames()) {
            Artifact[] configArtifacts;
            for (Artifact configArtifact : configArtifacts = this.getDescriptor().getArtifacts(string)) {
                this.artifactsByConfig.put((Object)string, artifactToMetaData.get(configArtifact));
            }
        }
    }
}

