/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.store;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.gradle.api.internal.cache.BinaryStore;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.io.RandomAccessFileInputStream;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.kryo.KryoBackedDecoder;
import org.gradle.messaging.serialize.kryo.KryoBackedEncoder;

class DefaultBinaryStore
implements BinaryStore,
Closeable {
    private File file;
    private KryoBackedEncoder encoder;
    private int offset = -1;

    public DefaultBinaryStore(File file) {
        this.file = file;
    }

    public void write(BinaryStore.WriteAction write) {
        if (this.encoder == null) {
            try {
                this.encoder = new KryoBackedEncoder((OutputStream)new FileOutputStream(this.file));
            }
            catch (FileNotFoundException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        if (this.offset == -1) {
            this.offset = this.encoder.getWritePosition();
            if (this.offset == Integer.MAX_VALUE) {
                throw new IllegalStateException("Unable to write to binary store. The bytes offset has reached a point where using it is unsafe. Please report this error.");
            }
        }
        try {
            write.write((Encoder)this.encoder);
        }
        catch (Exception e) {
            throw new RuntimeException("Problems writing to " + this.diagnose(), e);
        }
    }

    private String diagnose() {
        return this.toString() + " (exist: " + this.file.exists() + ")";
    }

    public String toString() {
        return "Binary store in " + this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryStore.BinaryData done() {
        try {
            if (this.encoder != null) {
                this.encoder.flush();
            }
            SimpleBinaryData simpleBinaryData = new SimpleBinaryData(this.file, this.offset, this.diagnose());
            return simpleBinaryData;
        }
        finally {
            this.offset = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.encoder != null) {
                this.encoder.close();
            }
        }
        finally {
            this.file.delete();
            this.encoder = null;
            this.file = null;
        }
    }

    File getFile() {
        return this.file;
    }

    long getSize() {
        return this.file.length();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleBinaryData
    implements BinaryStore.BinaryData {
        private final int offset;
        private final File inputFile;
        private final String sourceDescription;
        private Decoder decoder;
        private CompositeStoppable resources;

        public SimpleBinaryData(File inputFile, int offset, String sourceDescription) {
            this.inputFile = inputFile;
            this.offset = offset;
            this.sourceDescription = sourceDescription;
        }

        public <T> T read(BinaryStore.ReadAction<T> readAction) {
            try {
                if (this.decoder == null) {
                    RandomAccessFile randomAccess = new RandomAccessFile(this.inputFile, "r");
                    randomAccess.seek(this.offset);
                    this.decoder = new KryoBackedDecoder((InputStream)new RandomAccessFileInputStream(randomAccess));
                    this.resources = new CompositeStoppable().add(new Object[]{randomAccess, this.decoder});
                }
                return (T)readAction.read(this.decoder);
            }
            catch (Exception e) {
                throw new RuntimeException("Problems reading data from " + this.sourceDescription, e);
            }
        }

        public void close() {
            try {
                if (this.resources != null) {
                    this.resources.stop();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Problems cleaning resources of " + this.sourceDescription, e);
            }
            finally {
                this.decoder = null;
                this.resources = null;
            }
        }

        public String toString() {
            return this.sourceDescription;
        }
    }
}

