/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleRevisionResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ModuleConflict;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultModuleConflict
implements ModuleConflict {
    private final Collection<ModuleRevisionResolveState> moduleVersions = new LinkedHashSet<ModuleRevisionResolveState>();
    private final Collection<ModuleRevisionResolveState> replacedVersions = new LinkedHashSet<ModuleRevisionResolveState>();

    public DefaultModuleConflict(Collection<? extends ModuleRevisionResolveState> moduleVersions) {
        this.addVersions(moduleVersions);
    }

    public void addVersions(Collection<? extends ModuleRevisionResolveState> moduleVersions) {
        this.moduleVersions.addAll(moduleVersions);
    }

    public Collection<? extends ModuleRevisionResolveState> getVersions() {
        if (!this.replacedVersions.isEmpty()) {
            return this.replacedVersions;
        }
        return this.moduleVersions;
    }

    @Override
    public void withAffectedModules(Action<ModuleIdentifier> affectedModulesAction) {
        HashSet<ModuleIdentifier> visited = new HashSet<ModuleIdentifier>();
        DefaultModuleConflict.withAffectedModules(this.moduleVersions, affectedModulesAction, visited);
        DefaultModuleConflict.withAffectedModules(this.replacedVersions, affectedModulesAction, visited);
    }

    private static void withAffectedModules(Collection<ModuleRevisionResolveState> versions, Action<ModuleIdentifier> affectedModulesAction, HashSet<ModuleIdentifier> visited) {
        for (ModuleRevisionResolveState v : versions) {
            ModuleIdentifier module = v.getId().getModule();
            if (!visited.add(module)) continue;
            affectedModulesAction.execute((Object)module);
        }
    }

    public void replacedBy(Collection<? extends ModuleRevisionResolveState> versions) {
        this.replacedVersions.addAll(versions);
    }
}

