/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleRevisionResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CandidateModule;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultConflictResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultModuleConflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ModuleConflict;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictHandler {
    private static final Logger LOGGER = Logging.getLogger(ConflictHandler.class);
    private final ModuleConflictResolver conflictResolver;
    private final Map<ModuleIdentifier, DefaultModuleConflict> conflicts = new LinkedHashMap<ModuleIdentifier, DefaultModuleConflict>();
    private final Map<ModuleIdentifier, CandidateModule> modules = new HashMap<ModuleIdentifier, CandidateModule>();
    private final Map<ModuleIdentifier, CandidateModule> targetToSource = new LinkedHashMap<ModuleIdentifier, CandidateModule>();

    public ConflictHandler(ModuleConflictResolver conflictResolver) {
        this.conflictResolver = conflictResolver;
    }

    @Nullable
    public ModuleConflict registerModule(CandidateModule newModule, ModuleIdentifier replacedBy) {
        CandidateModule replacementSource;
        this.modules.put(newModule.getId(), newModule);
        if (replacedBy != null) {
            this.targetToSource.put(replacedBy, newModule);
            CandidateModule replacement = this.modules.get(replacedBy);
            if (replacement != null) {
                DefaultModuleConflict result = this.createOrGetConflict(newModule);
                DefaultModuleConflict replacementConflict = this.conflicts.remove(replacement.getId());
                if (replacementConflict != null) {
                    result.replacedBy(replacementConflict.getVersions());
                } else {
                    result.replacedBy(replacement.getVersions());
                }
                return result;
            }
        }
        if ((replacementSource = this.targetToSource.get(newModule.getId())) != null) {
            DefaultModuleConflict result = this.createOrGetConflict(replacementSource);
            result.replacedBy(newModule.getVersions());
            return result;
        }
        if (newModule.getVersions().size() > 1) {
            return this.createOrGetConflict(newModule);
        }
        return null;
    }

    private DefaultModuleConflict createOrGetConflict(CandidateModule module) {
        DefaultModuleConflict c = this.conflicts.get(module.getId());
        if (c == null) {
            c = new DefaultModuleConflict(module.getVersions());
            this.conflicts.put(module.getId(), c);
        }
        c.addVersions(module.getVersions());
        return c;
    }

    public boolean hasConflicts() {
        return !this.conflicts.isEmpty();
    }

    public void resolveNextConflict(Action<ConflictResolutionResult> resolutionAction) {
        assert (this.hasConflicts());
        ModuleIdentifier first = this.conflicts.keySet().iterator().next();
        DefaultModuleConflict firstConflict = this.conflicts.remove(first);
        ModuleRevisionResolveState selected = this.conflictResolver.select(firstConflict.getVersions());
        DefaultConflictResolutionResult result = new DefaultConflictResolutionResult(firstConflict, selected);
        resolutionAction.execute((Object)result);
        LOGGER.debug("Selected {} from conflicting modules {}.", (Object)selected, firstConflict.getVersions());
    }
}

