/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.id.ModuleId;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactResolver;
import org.gradle.api.internal.artifacts.ivyservice.BuildableArtifactSetResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ComponentResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.DefaultBuildableArtifactSetResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.DefaultBuildableComponentResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.DefaultComponentUsage;
import org.gradle.api.internal.artifacts.ivyservice.DependencyToModuleVersionIdResolver;
import org.gradle.api.internal.artifacts.ivyservice.ModuleToModuleVersionResolver;
import org.gradle.api.internal.artifacts.ivyservice.ModuleVersionIdResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ModuleVersionResolveException;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.EnhancedDependencyDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.DependencyToConfigurationResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleRevisionResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleVersionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.CompositeDependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolutionResultDependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedConfigurationDependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CandidateModule;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ModuleConflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedConfigurationBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.InternalDependencyResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ModuleVersionSelection;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolutionResultBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ComponentMetaData;
import org.gradle.api.internal.artifacts.metadata.ConfigurationMetaData;
import org.gradle.api.internal.artifacts.metadata.DependencyMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyGraphBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyGraphBuilder.class);
    private final DependencyToModuleVersionIdResolver dependencyResolver;
    private final DependencyToConfigurationResolver dependencyToConfigurationResolver;
    private final ModuleConflictResolver conflictResolver;
    private final ModuleToModuleVersionResolver moduleResolver;
    private final ArtifactResolver artifactResolver;

    public DependencyGraphBuilder(DependencyToModuleVersionIdResolver dependencyResolver, ModuleToModuleVersionResolver moduleResolver, ArtifactResolver artifactResolver, ModuleConflictResolver conflictResolver, DependencyToConfigurationResolver dependencyToConfigurationResolver) {
        this.dependencyResolver = dependencyResolver;
        this.moduleResolver = moduleResolver;
        this.artifactResolver = artifactResolver;
        this.conflictResolver = conflictResolver;
        this.dependencyToConfigurationResolver = dependencyToConfigurationResolver;
    }

    public void resolve(ConfigurationInternal configuration, ResolutionResultBuilder newModelBuilder, ResolvedConfigurationBuilder oldModelBuilder) throws ResolveException {
        ResolvedConfigurationDependencyGraphVisitor oldModelVisitor = new ResolvedConfigurationDependencyGraphVisitor(oldModelBuilder, this.artifactResolver);
        ResolutionResultDependencyGraphVisitor newModelVisitor = new ResolutionResultDependencyGraphVisitor(newModelBuilder);
        CompositeDependencyGraphVisitor modelVisitor = new CompositeDependencyGraphVisitor(oldModelVisitor, newModelVisitor);
        this.resolveDependencyGraph(configuration, modelVisitor);
    }

    private void resolveDependencyGraph(ConfigurationInternal configuration, DependencyGraphVisitor modelVisitor) {
        DefaultBuildableComponentResolveResult rootModule = new DefaultBuildableComponentResolveResult();
        this.moduleResolver.resolve(configuration.getModule(), configuration.getAll(), rootModule);
        ResolveState resolveState = new ResolveState(rootModule, configuration.getName(), this.dependencyResolver, this.dependencyToConfigurationResolver, this.artifactResolver);
        ConflictHandler conflictHandler = new ConflictHandler(new DirectDependencyForcingResolver(this.conflictResolver, ((ResolveState)resolveState).root.moduleRevision));
        this.traverseGraph(resolveState, conflictHandler);
        this.assembleResult(resolveState, modelVisitor);
    }

    private void traverseGraph(final ResolveState resolveState, ConflictHandler conflictHandler) {
        resolveState.onMoreSelected(resolveState.root);
        ArrayList<DependencyEdge> dependencies = new ArrayList<DependencyEdge>();
        while (resolveState.peek() != null || conflictHandler.hasConflicts()) {
            if (resolveState.peek() != null) {
                ConfigurationNode node = resolveState.pop();
                LOGGER.debug("Visiting configuration {}.", (Object)node);
                dependencies.clear();
                node.visitOutgoingDependencies(dependencies);
                for (DependencyEdge dependency : dependencies) {
                    LOGGER.debug("Visiting dependency {}", (Object)dependency);
                    ModuleVersionResolveState moduleRevision = dependency.resolveModuleRevisionId();
                    if (moduleRevision == null) continue;
                    ModuleIdentifier moduleId = moduleRevision.id.getModule();
                    if (moduleRevision.state == ModuleState.New) {
                        ModuleResolveState module = resolveState.getModule(moduleId);
                        ModuleConflict c = conflictHandler.registerModule(module, moduleRevision.preferredTarget);
                        if (c == null) {
                            LOGGER.debug("Selecting new module version {}", (Object)moduleRevision);
                            module.select(moduleRevision);
                        } else {
                            LOGGER.debug("Found new conflicting module version {}", (Object)moduleRevision);
                            c.withAffectedModules(new Action<ModuleIdentifier>(){

                                public void execute(ModuleIdentifier module) {
                                    ModuleVersionResolveState previouslySelected = resolveState.getModule(module).clearSelection();
                                    if (previouslySelected != null) {
                                        for (ConfigurationNode configuration : previouslySelected.configurations) {
                                            configuration.deselect();
                                        }
                                    }
                                }
                            });
                        }
                    }
                    dependency.attachToTargetConfigurations();
                }
                continue;
            }
            conflictHandler.resolveNextConflict(new Action<ConflictResolutionResult>(){

                public void execute(final ConflictResolutionResult result) {
                    result.getConflict().withAffectedModules(new Action<ModuleIdentifier>(){

                        public void execute(ModuleIdentifier moduleIdentifier) {
                            ModuleVersionResolveState selected = (ModuleVersionResolveState)result.getSelected();
                            resolveState.getModule(moduleIdentifier).restart(selected);
                        }
                    });
                }
            });
        }
    }

    private void assembleResult(ResolveState resolveState, DependencyGraphVisitor listener) {
        listener.start(resolveState.root);
        for (ConfigurationNode resolvedConfiguration : resolveState.getConfigurationNodes()) {
            if (!resolvedConfiguration.isSelected()) continue;
            resolvedConfiguration.validate();
            listener.visitNode(resolvedConfiguration);
        }
        for (ConfigurationNode resolvedConfiguration : resolveState.getConfigurationNodes()) {
            if (!resolvedConfiguration.isSelected()) continue;
            listener.visitEdge(resolvedConfiguration);
        }
        listener.finish(resolveState.root);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DirectDependencyForcingResolver
    implements ModuleConflictResolver {
        private final ModuleConflictResolver resolver;
        private final ModuleVersionResolveState root;

        private DirectDependencyForcingResolver(ModuleConflictResolver resolver, ModuleVersionResolveState root) {
            this.resolver = resolver;
            this.root = root;
        }

        @Override
        public <T extends ModuleRevisionResolveState> T select(Collection<? extends T> candidates) {
            for (ConfigurationNode configuration : this.root.configurations) {
                for (DependencyEdge outgoingEdge : configuration.outgoingEdges) {
                    if (!outgoingEdge.dependencyDescriptor.isForce() || !candidates.contains(outgoingEdge.targetModuleRevision)) continue;
                    outgoingEdge.targetModuleRevision.selectionReason = VersionSelectionReasons.FORCED;
                    return (T)outgoingEdge.targetModuleRevision;
                }
            }
            return this.resolver.select(candidates);
        }
    }

    private static class ModuleVersionSelectorResolveState {
        final DependencyMetaData dependencyMetaData;
        final DependencyToModuleVersionIdResolver resolver;
        final ResolveState resolveState;
        ModuleVersionResolveException failure;
        ModuleResolveState targetModule;
        ModuleVersionResolveState targetModuleRevision;
        ModuleVersionIdResolveResult idResolveResult;

        private ModuleVersionSelectorResolveState(DependencyMetaData dependencyMetaData, DependencyToModuleVersionIdResolver resolver, ResolveState resolveState) {
            this.dependencyMetaData = dependencyMetaData;
            this.resolver = resolver;
            this.resolveState = resolveState;
            this.targetModule = resolveState.getModule(new DefaultModuleIdentifier(dependencyMetaData.getRequested().getGroup(), dependencyMetaData.getRequested().getName()));
        }

        public String toString() {
            return this.dependencyMetaData.toString();
        }

        private ModuleVersionResolveException getFailure() {
            return this.failure != null ? this.failure : this.targetModuleRevision.getFailure();
        }

        public ComponentSelectionReason getSelectionReason() {
            return this.targetModuleRevision == null ? this.idResolveResult.getSelectionReason() : this.targetModuleRevision.getSelectionReason();
        }

        public ModuleVersionResolveState getSelected() {
            return this.targetModule.selected;
        }

        public ModuleResolveState getSelectedModule() {
            return this.targetModule;
        }

        public ModuleVersionResolveState resolveModuleRevisionId() {
            if (this.targetModuleRevision != null) {
                return this.targetModuleRevision;
            }
            if (this.failure != null) {
                return null;
            }
            this.idResolveResult = this.resolver.resolve(this.dependencyMetaData);
            if (this.idResolveResult.getFailure() != null) {
                this.failure = this.idResolveResult.getFailure();
                return null;
            }
            this.targetModuleRevision = this.resolveState.getRevision(this.idResolveResult.getId());
            this.targetModuleRevision.addResolver(this);
            this.targetModuleRevision.selectionReason = this.idResolveResult.getSelectionReason();
            this.targetModuleRevision.preferredTarget = this.idResolveResult.getPreferredTarget();
            this.targetModule = this.targetModuleRevision.module;
            this.targetModule.addSelector(this);
            return this.targetModuleRevision;
        }

        public void restart(ModuleVersionResolveState moduleRevision) {
            this.targetModuleRevision = moduleRevision;
            this.targetModule = moduleRevision.module;
        }
    }

    private static class RootConfigurationNode
    extends ConfigurationNode {
        private RootConfigurationNode(ModuleVersionResolveState moduleRevision, ResolvedConfigurationIdentifier id, ResolveState resolveState) {
            super(moduleRevision, id, resolveState);
        }

        public boolean isSelected() {
            return true;
        }

        public void deselect() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConfigurationNode {
        public final ModuleVersionResolveState moduleRevision;
        public final ConfigurationMetaData metaData;
        public final Set<DependencyEdge> incomingEdges = new LinkedHashSet<DependencyEdge>();
        public final Set<DependencyEdge> outgoingEdges = new LinkedHashSet<DependencyEdge>();
        public final ResolvedConfigurationIdentifier id;
        private final ResolveState resolveState;
        private ModuleVersionSpec previousTraversal;
        private Set<ResolvedArtifact> artifacts;

        private ConfigurationNode(ModuleVersionResolveState moduleRevision, ResolvedConfigurationIdentifier id, ResolveState resolveState) {
            this.moduleRevision = moduleRevision;
            this.resolveState = resolveState;
            this.metaData = moduleRevision.metaData.getConfiguration(id.getConfiguration());
            this.id = id;
            moduleRevision.addConfiguration(this);
        }

        public ModuleVersionIdentifier toId() {
            return this.moduleRevision.id;
        }

        public String toString() {
            return String.format("%s(%s)", this.moduleRevision, this.metaData.getName());
        }

        public Set<ResolvedArtifact> getArtifacts(ResolvedConfigurationBuilder builder) {
            if (this.artifacts == null) {
                this.artifacts = new LinkedHashSet<ResolvedArtifact>();
                DefaultBuildableArtifactSetResolveResult result = new DefaultBuildableArtifactSetResolveResult();
                this.resolveState.artifactResolver.resolveModuleArtifacts(this.metaData.getComponent(), new DefaultComponentUsage(this.metaData.getName()), (BuildableArtifactSetResolveResult)result);
                for (ComponentArtifactMetaData artifact : result.getArtifacts()) {
                    this.artifacts.add(builder.newArtifact(this.id, this.metaData.getComponent(), artifact, this.resolveState.artifactResolver));
                }
            }
            return this.artifacts;
        }

        public boolean isTransitive() {
            return this.metaData.isTransitive();
        }

        public void visitOutgoingDependencies(Collection<DependencyEdge> target) {
            if (this.moduleRevision.state != ModuleState.Selected) {
                LOGGER.debug("version for {} is not selected. ignoring.", (Object)this);
                return;
            }
            ArrayList<DependencyEdge> transitiveIncoming = new ArrayList<DependencyEdge>();
            for (DependencyEdge edge : this.incomingEdges) {
                if (!edge.isTransitive()) continue;
                transitiveIncoming.add(edge);
            }
            if (transitiveIncoming.isEmpty() && this != this.resolveState.root) {
                if (this.previousTraversal != null) {
                    this.removeOutgoingEdges();
                }
                if (this.incomingEdges.isEmpty()) {
                    LOGGER.debug("{} has no incoming edges. ignoring.", (Object)this);
                } else {
                    LOGGER.debug("{} has no transitive incoming edges. ignoring outgoing edges.", (Object)this);
                }
                return;
            }
            ModuleVersionSpec selectorSpec = this.getSelector(transitiveIncoming);
            if (this.previousTraversal != null) {
                if (this.previousTraversal.acceptsSameModulesAs(selectorSpec)) {
                    LOGGER.debug("Changed edges for {} selects same versions as previous traversal. ignoring", (Object)this);
                    return;
                }
                this.removeOutgoingEdges();
            }
            for (DependencyMetaData dependency : this.metaData.getDependencies()) {
                DependencyDescriptor dependencyDescriptor = dependency.getDescriptor();
                ModuleId targetModuleId = dependencyDescriptor.getDependencyRevisionId().getModuleId();
                if (!selectorSpec.isSatisfiedBy(targetModuleId)) {
                    LOGGER.debug("{} is excluded from {}.", (Object)targetModuleId, (Object)this);
                    continue;
                }
                DependencyEdge dependencyEdge = new DependencyEdge(this, dependency, selectorSpec, this.resolveState);
                this.outgoingEdges.add(dependencyEdge);
                target.add(dependencyEdge);
            }
            this.previousTraversal = selectorSpec;
        }

        public void addIncomingEdge(DependencyEdge dependencyEdge) {
            this.incomingEdges.add(dependencyEdge);
            this.resolveState.onMoreSelected(this);
        }

        public void removeIncomingEdge(DependencyEdge dependencyEdge) {
            this.incomingEdges.remove(dependencyEdge);
            this.resolveState.onFewerSelected(this);
        }

        public boolean isSelected() {
            return this.moduleRevision.state == ModuleState.Selected;
        }

        private ModuleVersionSpec getSelector(List<DependencyEdge> transitiveEdges) {
            ModuleVersionSpec selector;
            if (transitiveEdges.isEmpty()) {
                selector = ModuleVersionSpec.forExcludes(new ExcludeRule[0]);
            } else {
                selector = transitiveEdges.get(0).getSelector();
                for (int i = 1; i < transitiveEdges.size(); ++i) {
                    DependencyEdge dependencyEdge = transitiveEdges.get(i);
                    selector = selector.union(dependencyEdge.getSelector());
                }
            }
            selector = selector.intersect(ModuleVersionSpec.forExcludes(this.metaData.getExcludeRules()));
            return selector;
        }

        public void removeOutgoingEdges() {
            for (DependencyEdge outgoingDependency : this.outgoingEdges) {
                outgoingDependency.removeFromTargetConfigurations();
            }
            this.outgoingEdges.clear();
            this.previousTraversal = null;
        }

        public void restart(ModuleVersionResolveState selected) {
            if (this.moduleRevision == selected) {
                this.resolveState.onMoreSelected(this);
            } else {
                for (DependencyEdge dependency : this.incomingEdges) {
                    dependency.restart(selected);
                }
                this.incomingEdges.clear();
            }
        }

        public void validate() {
            for (DependencyEdge incomingEdge : this.incomingEdges) {
                ConfigurationNode fromNode = incomingEdge.from;
                if (fromNode.isSelected()) continue;
                throw new IllegalStateException(String.format("Unexpected state %s for parent node for dependency from %s to %s.", new Object[]{fromNode.moduleRevision.state, fromNode, this}));
            }
        }

        public void deselect() {
            this.removeOutgoingEdges();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ModuleVersionResolveState
    implements ModuleRevisionResolveState,
    ModuleVersionSelection {
        public final ModuleVersionIdentifier id;
        private final Set<ConfigurationNode> configurations = new LinkedHashSet<ConfigurationNode>();
        private final ModuleResolveState module;
        private ComponentMetaData metaData;
        private ModuleState state = ModuleState.New;
        private ComponentSelectionReason selectionReason = VersionSelectionReasons.REQUESTED;
        private ModuleVersionIdResolveResult idResolveResult;
        private ComponentResolveResult resolveResult;
        private ModuleVersionResolveException failure;
        @Nullable
        private ModuleIdentifier preferredTarget;

        private ModuleVersionResolveState(ModuleResolveState module, ModuleVersionIdentifier id) {
            this.module = module;
            this.id = id;
        }

        public String toString() {
            return this.id.toString();
        }

        @Override
        public String getVersion() {
            return this.id.getVersion();
        }

        @Override
        public ModuleVersionIdentifier getId() {
            return this.id;
        }

        public ModuleVersionResolveException getFailure() {
            return this.failure;
        }

        public void restart(ModuleVersionResolveState selected) {
            for (ConfigurationNode configuration : this.configurations) {
                configuration.restart(selected);
            }
        }

        public void addResolver(ModuleVersionSelectorResolveState resolver) {
            if (this.idResolveResult == null) {
                this.idResolveResult = resolver.idResolveResult;
            }
        }

        public ComponentResolveResult resolve() {
            if (this.resolveResult != null) {
                return this.resolveResult;
            }
            if (this.failure != null) {
                return null;
            }
            this.resolveResult = this.idResolveResult.resolve();
            if (this.resolveResult.getFailure() != null) {
                this.failure = this.resolveResult.getFailure();
                return null;
            }
            this.setResolveResult(this.resolveResult);
            return this.resolveResult;
        }

        public ComponentMetaData getMetaData() {
            if (this.metaData == null) {
                this.resolve();
            }
            return this.metaData;
        }

        public void setResolveResult(ComponentResolveResult resolveResult) {
            this.resolveResult = resolveResult;
            this.metaData = resolveResult.getMetaData();
            this.failure = null;
        }

        public void addConfiguration(ConfigurationNode configurationNode) {
            this.configurations.add(configurationNode);
        }

        @Override
        public ComponentSelectionReason getSelectionReason() {
            return this.selectionReason;
        }

        @Override
        public void setSelectionReason(ComponentSelectionReason reason) {
            this.selectionReason = reason;
        }

        @Override
        public ComponentIdentifier getComponentId() {
            return this.getMetaData().getComponentId();
        }

        public List<ModuleVersionResolveState> getIncoming() {
            ArrayList<ModuleVersionResolveState> incoming = new ArrayList<ModuleVersionResolveState>();
            for (ConfigurationNode configuration : this.configurations) {
                for (DependencyEdge dependencyEdge : configuration.incomingEdges) {
                    incoming.add(dependencyEdge.from.moduleRevision);
                }
            }
            return incoming;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModuleResolveState
    implements CandidateModule {
        final ModuleIdentifier id;
        final Set<DependencyEdge> unattachedDependencies = new LinkedHashSet<DependencyEdge>();
        final Map<ModuleVersionIdentifier, ModuleVersionResolveState> versions = new LinkedHashMap<ModuleVersionIdentifier, ModuleVersionResolveState>();
        final Set<ModuleVersionSelectorResolveState> selectors = new HashSet<ModuleVersionSelectorResolveState>();
        final ResolveState resolveState;
        ModuleVersionResolveState selected;

        private ModuleResolveState(ModuleIdentifier id, ResolveState resolveState) {
            this.id = id;
            this.resolveState = resolveState;
        }

        public String toString() {
            return this.id.toString();
        }

        @Override
        public ModuleIdentifier getId() {
            return this.id;
        }

        public Collection<ModuleVersionResolveState> getVersions() {
            return this.versions.values();
        }

        public void select(ModuleVersionResolveState selected) {
            assert (this.selected == null);
            this.selected = selected;
            for (ModuleVersionResolveState version : this.versions.values()) {
                version.state = ModuleState.Evicted;
            }
            selected.state = ModuleState.Selected;
        }

        public ModuleVersionResolveState clearSelection() {
            ModuleVersionResolveState previousSelection = this.selected;
            this.selected = null;
            for (ModuleVersionResolveState version : this.versions.values()) {
                version.state = ModuleState.Conflict;
            }
            return previousSelection;
        }

        public void restart(ModuleVersionResolveState selected) {
            this.select(selected);
            for (ModuleVersionResolveState version : this.versions.values()) {
                version.restart(selected);
            }
            for (ModuleVersionSelectorResolveState selector : this.selectors) {
                selector.restart(selected);
            }
            for (DependencyEdge dependency : new ArrayList<DependencyEdge>(this.unattachedDependencies)) {
                dependency.restart(selected);
            }
            this.unattachedDependencies.clear();
        }

        public void addUnattachedDependency(DependencyEdge edge) {
            this.unattachedDependencies.add(edge);
        }

        public void removeUnattachedDependency(DependencyEdge edge) {
            this.unattachedDependencies.remove(edge);
        }

        public ModuleVersionResolveState getVersion(ModuleVersionIdentifier id) {
            ModuleVersionResolveState moduleRevision = this.versions.get(id);
            if (moduleRevision == null) {
                moduleRevision = new ModuleVersionResolveState(this, id);
                this.versions.put(id, moduleRevision);
            }
            return moduleRevision;
        }

        public void addSelector(ModuleVersionSelectorResolveState selector) {
            this.selectors.add(selector);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ModuleState {
        New,
        Selected,
        Conflict,
        Evicted;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolveState {
        private final Map<ModuleIdentifier, ModuleResolveState> modules = new LinkedHashMap<ModuleIdentifier, ModuleResolveState>();
        private final Map<ResolvedConfigurationIdentifier, ConfigurationNode> nodes = new LinkedHashMap<ResolvedConfigurationIdentifier, ConfigurationNode>();
        private final Map<ModuleVersionSelector, ModuleVersionSelectorResolveState> selectors = new LinkedHashMap<ModuleVersionSelector, ModuleVersionSelectorResolveState>();
        private final RootConfigurationNode root;
        private final DependencyToModuleVersionIdResolver resolver;
        private final DependencyToConfigurationResolver dependencyToConfigurationResolver;
        private final ArtifactResolver artifactResolver;
        private final Set<ConfigurationNode> queued = new HashSet<ConfigurationNode>();
        private final LinkedList<ConfigurationNode> queue = new LinkedList();

        public ResolveState(ComponentResolveResult rootResult, String rootConfigurationName, DependencyToModuleVersionIdResolver resolver, DependencyToConfigurationResolver dependencyToConfigurationResolver, ArtifactResolver artifactResolver) {
            this.resolver = resolver;
            this.dependencyToConfigurationResolver = dependencyToConfigurationResolver;
            this.artifactResolver = artifactResolver;
            ModuleVersionResolveState rootVersion = this.getRevision(rootResult.getId());
            rootVersion.setResolveResult(rootResult);
            this.root = new RootConfigurationNode(rootVersion, new ResolvedConfigurationIdentifier(rootVersion.id, rootConfigurationName), this);
            this.nodes.put(this.root.id, this.root);
            this.root.moduleRevision.module.select(this.root.moduleRevision);
        }

        public ModuleResolveState getModule(ModuleIdentifier id) {
            ModuleResolveState module = this.modules.get(id);
            if (module == null) {
                module = new ModuleResolveState(id, this);
                this.modules.put(id, module);
            }
            return module;
        }

        public ModuleVersionResolveState getRevision(ModuleVersionIdentifier id) {
            return this.getModule(id.getModule()).getVersion(id);
        }

        public Collection<ConfigurationNode> getConfigurationNodes() {
            return this.nodes.values();
        }

        public ConfigurationNode getConfigurationNode(ModuleVersionResolveState module, String configurationName) {
            ResolvedConfigurationIdentifier id = new ResolvedConfigurationIdentifier(module.id, configurationName);
            ConfigurationNode configuration = this.nodes.get(id);
            if (configuration == null) {
                configuration = new ConfigurationNode(module, id, this);
                this.nodes.put(id, configuration);
            }
            return configuration;
        }

        public ModuleVersionSelectorResolveState getSelector(DependencyMetaData dependencyMetaData) {
            ModuleVersionSelector requested = dependencyMetaData.getRequested();
            ModuleVersionSelectorResolveState resolveState = this.selectors.get(requested);
            if (resolveState == null) {
                resolveState = new ModuleVersionSelectorResolveState(dependencyMetaData, this.resolver, this);
                this.selectors.put(requested, resolveState);
            }
            return resolveState;
        }

        public ConfigurationNode peek() {
            return this.queue.isEmpty() ? null : this.queue.getFirst();
        }

        public ConfigurationNode pop() {
            ConfigurationNode next = this.queue.removeFirst();
            this.queued.remove(next);
            return next;
        }

        public void onMoreSelected(ConfigurationNode configuration) {
            if (this.queued.add(configuration)) {
                this.queue.addLast(configuration);
            }
        }

        public void onFewerSelected(ConfigurationNode configuration) {
            if (this.queued.add(configuration)) {
                this.queue.addFirst(configuration);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DependencyEdge
    implements InternalDependencyResult {
        public final ConfigurationNode from;
        public final ModuleVersionSelectorResolveState selector;
        private final DependencyMetaData dependencyMetaData;
        private final DependencyDescriptor dependencyDescriptor;
        private final ResolveState resolveState;
        private final ModuleVersionSpec selectorSpec;
        private final Set<ConfigurationNode> targetConfigurations = new LinkedHashSet<ConfigurationNode>();
        private ModuleVersionResolveState targetModuleRevision;

        public DependencyEdge(ConfigurationNode from, DependencyMetaData dependencyMetaData, ModuleVersionSpec selectorSpec, ResolveState resolveState) {
            this.from = from;
            this.dependencyMetaData = dependencyMetaData;
            this.dependencyDescriptor = dependencyMetaData.getDescriptor();
            this.selectorSpec = selectorSpec;
            this.resolveState = resolveState;
            this.selector = resolveState.getSelector(dependencyMetaData);
        }

        public String toString() {
            return String.format("%s -> %s(%s)", this.from.toString(), this.dependencyMetaData.getRequested(), this.dependencyDescriptor);
        }

        public ModuleVersionResolveState resolveModuleRevisionId() {
            if (this.targetModuleRevision == null) {
                this.targetModuleRevision = this.selector.resolveModuleRevisionId();
                this.selector.getSelectedModule().addUnattachedDependency(this);
            }
            return this.targetModuleRevision;
        }

        public boolean isTransitive() {
            return this.from.isTransitive() && this.dependencyMetaData.isTransitive();
        }

        public void attachToTargetConfigurations() {
            if (this.targetModuleRevision.state != ModuleState.Selected) {
                return;
            }
            this.calculateTargetConfigurations();
            for (ConfigurationNode targetConfiguration : this.targetConfigurations) {
                targetConfiguration.addIncomingEdge(this);
            }
            if (!this.targetConfigurations.isEmpty()) {
                this.selector.getSelectedModule().removeUnattachedDependency(this);
            }
        }

        public void removeFromTargetConfigurations() {
            for (ConfigurationNode targetConfiguration : this.targetConfigurations) {
                targetConfiguration.removeIncomingEdge(this);
            }
            this.targetConfigurations.clear();
            if (this.targetModuleRevision != null) {
                this.selector.getSelectedModule().removeUnattachedDependency(this);
            }
        }

        public void restart(ModuleVersionResolveState selected) {
            this.targetModuleRevision = selected;
            this.attachToTargetConfigurations();
        }

        private void calculateTargetConfigurations() {
            this.targetConfigurations.clear();
            ComponentMetaData targetModuleVersion = this.targetModuleRevision.getMetaData();
            if (targetModuleVersion == null) {
                return;
            }
            Set<ConfigurationMetaData> targetConfigurations = this.resolveState.dependencyToConfigurationResolver.resolveTargetConfigurations(this.dependencyMetaData, this.from.metaData, targetModuleVersion);
            for (ConfigurationMetaData targetConfiguration : targetConfigurations) {
                ConfigurationNode targetConfigurationNode = this.resolveState.getConfigurationNode(this.targetModuleRevision, targetConfiguration.getName());
                this.targetConfigurations.add(targetConfigurationNode);
            }
        }

        public ModuleVersionSpec getSelector() {
            String[] configurations = this.from.metaData.getHierarchy().toArray(new String[this.from.metaData.getHierarchy().size()]);
            ModuleVersionSpec selector = ModuleVersionSpec.forExcludes(this.dependencyDescriptor.getExcludeRules(configurations));
            return selector.intersect(this.selectorSpec);
        }

        @Override
        public ComponentSelector getRequested() {
            return this.dependencyMetaData.getSelector();
        }

        public ModuleVersionSelector getRequestedModuleVersion() {
            return this.dependencyMetaData.getRequested();
        }

        @Override
        public ModuleVersionResolveException getFailure() {
            return this.selector.getFailure();
        }

        @Override
        public ModuleVersionIdentifier getSelected() {
            return this.selector.getSelected().getId();
        }

        @Override
        public ComponentSelectionReason getReason() {
            return this.selector.getSelectionReason();
        }

        public ModuleDependency getModuleDependency() {
            return ((EnhancedDependencyDescriptor)this.dependencyDescriptor).getModuleDependency();
        }

        public Set<ComponentArtifactMetaData> getArtifacts(ConfigurationMetaData metaData1) {
            return this.dependencyMetaData.getArtifacts(this.from.metaData, metaData1);
        }
    }
}

