/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;

class CompositeDependencyGraphVisitor
implements DependencyGraphVisitor {
    private final List<DependencyGraphVisitor> visitors;

    CompositeDependencyGraphVisitor(DependencyGraphVisitor ... visitors) {
        this.visitors = Arrays.asList(visitors);
    }

    public void start(DependencyGraphBuilder.ConfigurationNode root) {
        for (DependencyGraphVisitor visitor : this.visitors) {
            visitor.start(root);
        }
    }

    public void visitNode(DependencyGraphBuilder.ConfigurationNode resolvedConfiguration) {
        for (DependencyGraphVisitor visitor : this.visitors) {
            visitor.visitNode(resolvedConfiguration);
        }
    }

    public void visitEdge(DependencyGraphBuilder.ConfigurationNode resolvedConfiguration) {
        for (DependencyGraphVisitor visitor : this.visitors) {
            visitor.visitEdge(resolvedConfiguration);
        }
    }

    public void finish(DependencyGraphBuilder.ConfigurationNode root) {
        for (DependencyGraphVisitor visitor : this.visitors) {
            visitor.finish(root);
        }
    }
}

