/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.DependencyToConfigurationResolver;
import org.gradle.api.internal.artifacts.metadata.ComponentMetaData;
import org.gradle.api.internal.artifacts.metadata.ConfigurationMetaData;
import org.gradle.api.internal.artifacts.metadata.DependencyMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependencyToConfigurationResolver
implements DependencyToConfigurationResolver {
    @Override
    public Set<ConfigurationMetaData> resolveTargetConfigurations(DependencyMetaData dependencyMetaData, ConfigurationMetaData fromConfiguration, ComponentMetaData targetComponent) {
        ModuleDescriptor targetDescriptor = targetComponent.getDescriptor();
        DependencyDescriptor dependencyDescriptor = dependencyMetaData.getDescriptor();
        LinkedHashSet<String> targetConfigurationNames = new LinkedHashSet<String>();
        for (String config : dependencyDescriptor.getModuleConfigurations()) {
            if (config.equals("*") || config.equals("%")) {
                this.collectTargetConfiguration(dependencyDescriptor, fromConfiguration, fromConfiguration.getName(), targetDescriptor, targetConfigurationNames);
                continue;
            }
            if (!fromConfiguration.getHierarchy().contains(config)) continue;
            this.collectTargetConfiguration(dependencyDescriptor, fromConfiguration, config, targetDescriptor, targetConfigurationNames);
        }
        LinkedHashSet<ConfigurationMetaData> targets = new LinkedHashSet<ConfigurationMetaData>();
        for (String targetConfigurationName : targetConfigurationNames) {
            if (targetDescriptor.getConfiguration(targetConfigurationName) == null) {
                throw new RuntimeException(String.format("Module version %s, configuration '%s' declares a dependency on configuration '%s' which is not declared in the module descriptor for %s", fromConfiguration.getComponent().getId(), fromConfiguration.getName(), targetConfigurationName, targetComponent.getId()));
            }
            ConfigurationMetaData targetConfiguration = targetComponent.getConfiguration(targetConfigurationName);
            targets.add(targetConfiguration);
        }
        return targets;
    }

    private void collectTargetConfiguration(DependencyDescriptor dependencyDescriptor, ConfigurationMetaData fromConfiguration, String mappingRhs, ModuleDescriptor targetModule, Collection<String> targetConfigs) {
        String[] dependencyConfigurations;
        for (String target : dependencyConfigurations = dependencyDescriptor.getDependencyConfigurations(mappingRhs, fromConfiguration.getName())) {
            String candidate = target;
            int startFallback = candidate.indexOf(40);
            if (startFallback >= 0 && candidate.charAt(candidate.length() - 1) == ')') {
                String preferred = candidate.substring(0, startFallback);
                if (targetModule.getConfiguration(preferred) != null) {
                    targetConfigs.add(preferred);
                    continue;
                }
                candidate = candidate.substring(startFallback + 1, candidate.length() - 1);
            }
            if (candidate.equals("*")) {
                Collections.addAll(targetConfigs, targetModule.getPublicConfigurationsNames());
                continue;
            }
            targetConfigs.add(candidate);
        }
    }
}

