/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DependencyResolveDetailsInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleForcingResolveRule
implements Action<DependencyResolveDetailsInternal> {
    private final Map<ModuleIdentifier, String> forcedModules;

    public ModuleForcingResolveRule(Collection<? extends ModuleVersionSelector> forcedModules) {
        if (!forcedModules.isEmpty()) {
            this.forcedModules = new HashMap<ModuleIdentifier, String>();
            for (ModuleVersionSelector moduleVersionSelector : forcedModules) {
                this.forcedModules.put(new DefaultModuleIdentifier(moduleVersionSelector.getGroup(), moduleVersionSelector.getName()), moduleVersionSelector.getVersion());
            }
        } else {
            this.forcedModules = null;
        }
    }

    public void execute(DependencyResolveDetailsInternal details) {
        if (this.forcedModules == null) {
            return;
        }
        DefaultModuleIdentifier key = new DefaultModuleIdentifier(details.getRequested().getGroup(), details.getRequested().getName());
        if (this.forcedModules.containsKey(key)) {
            details.useVersion(this.forcedModules.get(key), VersionSelectionReasons.FORCED);
        }
    }
}

