/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import java.util.Set;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.ivyservice.BuildableComponentResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.DependencyToModuleVersionResolver;
import org.gradle.api.internal.artifacts.ivyservice.LocalComponentFactory;
import org.gradle.api.internal.artifacts.ivyservice.ModuleToModuleVersionResolver;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ProjectDependencyDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectComponentRegistry;
import org.gradle.api.internal.artifacts.metadata.DependencyMetaData;
import org.gradle.api.internal.artifacts.metadata.LocalComponentMetaData;
import org.gradle.api.internal.artifacts.metadata.MutableLocalComponentMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDependencyResolver
implements DependencyToModuleVersionResolver,
ModuleToModuleVersionResolver {
    private final ProjectComponentRegistry projectComponentRegistry;
    private final DependencyToModuleVersionResolver delegate;
    private final LocalComponentFactory localComponentFactory;

    public ProjectDependencyResolver(ProjectComponentRegistry projectComponentRegistry, LocalComponentFactory localComponentFactory, DependencyToModuleVersionResolver delegate) {
        this.projectComponentRegistry = projectComponentRegistry;
        this.delegate = delegate;
        this.localComponentFactory = localComponentFactory;
    }

    @Override
    public void resolve(DependencyMetaData dependency, BuildableComponentResolveResult result) {
        DependencyDescriptor descriptor = dependency.getDescriptor();
        if (descriptor instanceof ProjectDependencyDescriptor) {
            ProjectDependencyDescriptor desc = (ProjectDependencyDescriptor)descriptor;
            LocalComponentMetaData componentMetaData = this.projectComponentRegistry.getProject(desc.getTargetProject().getPath());
            result.resolved(componentMetaData.toResolveMetaData());
        } else {
            this.delegate.resolve(dependency, result);
        }
    }

    @Override
    public void resolve(ModuleInternal module, Set<? extends Configuration> configurations, BuildableComponentResolveResult result) {
        MutableLocalComponentMetaData componentMetaData = this.localComponentFactory.convert(configurations, module);
        result.resolved(componentMetaData.toResolveMetaData());
    }
}

