/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import java.util.Set;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Module;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.LocalComponentFactory;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ConfigurationsToArtifactsConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ConfigurationsToModuleDescriptorConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ModuleDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependenciesToModuleDescriptorConverter;
import org.gradle.api.internal.artifacts.metadata.DefaultLocalComponentMetaData;
import org.gradle.api.internal.artifacts.metadata.MutableLocalComponentMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveLocalComponentFactory
implements LocalComponentFactory {
    static final String IVY_MAVEN_NAMESPACE = "http://ant.apache.org/ivy/maven";
    static final String IVY_MAVEN_NAMESPACE_PREFIX = "m";
    private final ModuleDescriptorFactory moduleDescriptorFactory;
    private final ConfigurationsToModuleDescriptorConverter configurationsToModuleDescriptorConverter;
    private final DependenciesToModuleDescriptorConverter dependenciesToModuleDescriptorConverter;
    private final ComponentIdentifierFactory componentIdentifierFactory;
    private final ConfigurationsToArtifactsConverter configurationsToArtifactsConverter;

    public ResolveLocalComponentFactory(ModuleDescriptorFactory moduleDescriptorFactory, ConfigurationsToModuleDescriptorConverter configurationsToModuleDescriptorConverter, DependenciesToModuleDescriptorConverter dependenciesToModuleDescriptorConverter, ComponentIdentifierFactory componentIdentifierFactory, ConfigurationsToArtifactsConverter configurationsToArtifactsConverter) {
        this.moduleDescriptorFactory = moduleDescriptorFactory;
        this.configurationsToModuleDescriptorConverter = configurationsToModuleDescriptorConverter;
        this.dependenciesToModuleDescriptorConverter = dependenciesToModuleDescriptorConverter;
        this.componentIdentifierFactory = componentIdentifierFactory;
        this.configurationsToArtifactsConverter = configurationsToArtifactsConverter;
    }

    @Override
    public MutableLocalComponentMetaData convert(Set<? extends Configuration> configurations, ModuleInternal module) {
        assert (configurations.size() > 0) : "No configurations found for module: " + module.getName() + ". Configure them or apply a plugin that does it.";
        DefaultModuleDescriptor moduleDescriptor = this.moduleDescriptorFactory.createModuleDescriptor((Module)module);
        moduleDescriptor.addExtraAttributeNamespace(IVY_MAVEN_NAMESPACE_PREFIX, IVY_MAVEN_NAMESPACE);
        ComponentIdentifier componentIdentifier = this.componentIdentifierFactory.createComponentIdentifier(module);
        DefaultLocalComponentMetaData metaData = new DefaultLocalComponentMetaData(moduleDescriptor, componentIdentifier);
        this.configurationsToModuleDescriptorConverter.addConfigurations(metaData, configurations);
        this.dependenciesToModuleDescriptorConverter.addDependencyDescriptors(metaData, configurations);
        this.configurationsToArtifactsConverter.addArtifacts(metaData, configurations);
        return metaData;
    }
}

