/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.math.BigInteger;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleSource;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleDescriptorCacheEntry;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.DefaultSerializer;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModuleDescriptorCacheEntrySerializer
implements Serializer<ModuleDescriptorCacheEntry> {
    private final DefaultSerializer<ModuleSource> moduleSourceSerializer = new DefaultSerializer(ModuleSource.class.getClassLoader());

    ModuleDescriptorCacheEntrySerializer() {
    }

    public void write(Encoder encoder, ModuleDescriptorCacheEntry value) throws Exception {
        encoder.writeByte(value.type);
        encoder.writeBoolean(value.isChanging);
        encoder.writeNullableString((CharSequence)value.packaging);
        encoder.writeLong(value.createTimestamp);
        this.moduleSourceSerializer.write(encoder, (Object)value.moduleSource);
        byte[] hash = value.moduleDescriptorHash.toByteArray();
        encoder.writeBinary(hash);
    }

    public ModuleDescriptorCacheEntry read(Decoder decoder) throws Exception {
        byte type = decoder.readByte();
        boolean isChanging = decoder.readBoolean();
        String packaging = decoder.readNullableString();
        long createTimestamp = decoder.readLong();
        ModuleSource moduleSource = (ModuleSource)this.moduleSourceSerializer.read(decoder);
        byte[] encodedHash = decoder.readBinary();
        BigInteger hash = new BigInteger(encodedHash);
        return new ModuleDescriptorCacheEntry(type, isChanging, packaging, createTimestamp, hash, moduleSource);
    }
}

