/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.math.BigInteger;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleSource;
import org.gradle.api.internal.artifacts.metadata.DefaultIvyModuleVersionMetaData;
import org.gradle.api.internal.artifacts.metadata.DefaultMavenModuleVersionMetaData;
import org.gradle.api.internal.artifacts.metadata.IvyModuleVersionMetaData;
import org.gradle.api.internal.artifacts.metadata.MavenModuleVersionMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionMetaData;
import org.gradle.api.internal.artifacts.metadata.MutableModuleVersionMetaData;

class ModuleDescriptorCacheEntry {
    private static final byte TYPE_MISSING = 0;
    private static final byte TYPE_IVY = 1;
    private static final byte TYPE_MAVEN = 2;
    public byte type;
    public boolean isChanging;
    public String packaging;
    public long createTimestamp;
    public ModuleSource moduleSource;
    public BigInteger moduleDescriptorHash;

    ModuleDescriptorCacheEntry(byte type, boolean isChanging, String packaging, long createTimestamp, BigInteger moduleDescriptorHash, ModuleSource moduleSource) {
        this.type = type;
        this.isChanging = isChanging;
        this.packaging = packaging;
        this.createTimestamp = createTimestamp;
        this.moduleSource = moduleSource;
        this.moduleDescriptorHash = moduleDescriptorHash;
    }

    public static ModuleDescriptorCacheEntry forMissingModule(long createTimestamp) {
        return new ModuleDescriptorCacheEntry(0, false, null, createTimestamp, BigInteger.ZERO, null);
    }

    public static ModuleDescriptorCacheEntry forMetaData(ModuleVersionMetaData metaData, long createTimestamp, BigInteger moduleDescriptorHash, ModuleSource moduleSource) {
        byte type = ModuleDescriptorCacheEntry.getType(metaData);
        String packaging = ModuleDescriptorCacheEntry.getPackaging(metaData);
        return new ModuleDescriptorCacheEntry(type, metaData.isChanging(), packaging, createTimestamp, moduleDescriptorHash, moduleSource);
    }

    private static String getPackaging(ModuleVersionMetaData metaData) {
        return metaData instanceof MavenModuleVersionMetaData ? ((MavenModuleVersionMetaData)metaData).getPackaging() : null;
    }

    private static byte getType(ModuleVersionMetaData metaData) {
        if (metaData == null) {
            return 0;
        }
        if (metaData instanceof IvyModuleVersionMetaData) {
            return 1;
        }
        if (metaData instanceof MavenModuleVersionMetaData) {
            return 2;
        }
        throw new IllegalArgumentException("Not a valid module version type: " + metaData);
    }

    public boolean isMissing() {
        return this.type == 0;
    }

    public MutableModuleVersionMetaData createMetaData(ModuleDescriptor descriptor) {
        switch (this.type) {
            case 1: {
                return this.configure(new DefaultIvyModuleVersionMetaData(descriptor));
            }
            case 2: {
                return this.configure(new DefaultMavenModuleVersionMetaData(descriptor, this.packaging, false));
            }
        }
        return null;
    }

    private MutableModuleVersionMetaData configure(MutableModuleVersionMetaData input) {
        input.setChanging(this.isChanging);
        return input;
    }
}

