/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import java.util.Comparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionMatcher;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionMetaData;

public class SubVersionMatcher
implements VersionMatcher {
    private final Comparator<String> staticVersionComparator;

    public SubVersionMatcher(VersionMatcher staticVersionComparator) {
        this.staticVersionComparator = staticVersionComparator;
    }

    public boolean canHandle(String selector) {
        return selector.endsWith("+");
    }

    public boolean isDynamic(String selector) {
        return true;
    }

    public boolean needModuleMetadata(String selector) {
        return false;
    }

    public boolean accept(String selector, String candidate) {
        String prefix = selector.substring(0, selector.length() - 1);
        return candidate.startsWith(prefix);
    }

    public boolean accept(String selector, ModuleVersionMetaData candidate) {
        return this.accept(selector, candidate.getId().getVersion());
    }

    public int compare(String selector, String candidate) {
        if (this.accept(selector, candidate)) {
            return 1;
        }
        return this.staticVersionComparator.compare(selector, candidate);
    }
}

