/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.ivy.plugins.matcher.ExactOrRegexpPatternMatcher;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.GlobPatternMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.matcher.RegexpPatternMatcher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.ChainVersionMatcher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.ExactVersionMatcher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestVersionMatcher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.SubVersionMatcher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionMatcher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionRangeMatcher;

public class ResolverStrategy {
    private final VersionMatcher versionMatcher;
    private final Map<String, PatternMatcher> matchers = Maps.newHashMap();

    public ResolverStrategy() {
        ChainVersionMatcher chain = new ChainVersionMatcher();
        chain.add(new VersionRangeMatcher(new ExactVersionMatcher()));
        chain.add(new SubVersionMatcher(new ExactVersionMatcher()));
        chain.add(new LatestVersionMatcher());
        chain.add(new ExactVersionMatcher());
        this.versionMatcher = chain;
        this.addMatcher((PatternMatcher)ExactPatternMatcher.INSTANCE);
        this.addMatcher((PatternMatcher)RegexpPatternMatcher.INSTANCE);
        this.addMatcher((PatternMatcher)ExactOrRegexpPatternMatcher.INSTANCE);
        this.addMatcher((PatternMatcher)GlobPatternMatcher.INSTANCE);
    }

    private void addMatcher(PatternMatcher instance) {
        this.matchers.put(instance.getName(), instance);
    }

    public VersionMatcher getVersionMatcher() {
        return this.versionMatcher;
    }

    public PatternMatcher getPatternMatcher(String name) {
        return this.matchers.get(name);
    }
}

