/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.IvyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvyMDArtifact {
    private Set<String> configurations = new LinkedHashSet<String>();
    private final DefaultModuleDescriptor md;
    private final String artName;
    private final String type;
    private final String ext;
    private final URL url;
    private final Map<String, String> extraAttributes;

    public IvyMDArtifact(DefaultModuleDescriptor md, String artName, String type, String ext, URL url, Map<String, String> extraAttributes) {
        this.md = md;
        this.artName = artName;
        this.type = type;
        this.ext = ext;
        this.url = url;
        this.extraAttributes = extraAttributes;
    }

    public IvyMDArtifact(DefaultModuleDescriptor md, String artName, String type, String ext) {
        this(md, artName, type, ext, null, null);
    }

    public IvyMDArtifact addConfiguration(String confName) {
        this.configurations.add(confName);
        return this;
    }

    public Set<String> getConfigurations() {
        return this.configurations;
    }

    public void addTo(DefaultModuleDescriptor target) {
        Artifact[] allArtifacts;
        if (this.configurations.isEmpty()) {
            throw new IllegalArgumentException("Artifact should be attached to at least one configuration.");
        }
        MDArtifact newArtifact = new MDArtifact((ModuleDescriptor)this.md, this.artName, this.type, this.ext, this.url, this.extraAttributes);
        for (Artifact existing : allArtifacts = target.getAllArtifacts()) {
            if (!IvyUtil.artifactsEqual(existing, (Artifact)newArtifact)) continue;
            if (!(existing instanceof MDArtifact)) {
                throw new IllegalArgumentException("Cannot update an existing artifact (" + existing + ") in provided module descriptor (" + target + ")" + " because the artifact is not an instance of MDArtifact." + target);
            }
            IvyMDArtifact.addArtifact((MDArtifact)existing, this.configurations, target);
            return;
        }
        IvyMDArtifact.addArtifact(newArtifact, this.configurations, target);
    }

    private static void addArtifact(MDArtifact artifact, Set<String> configurations, DefaultModuleDescriptor target) {
        LinkedHashSet existingConfigurations = Sets.newLinkedHashSet(Arrays.asList(artifact.getConfigurations()));
        for (String c : configurations) {
            if (existingConfigurations.contains(c)) continue;
            artifact.addConfiguration(c);
            target.addArtifact(c, (Artifact)artifact);
        }
    }
}

