/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.AbstractModuleDescriptorParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.DescriptorParseContext;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.GradlePomModuleDescriptorBuilder;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.PomReader;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.data.MavenDependencyKey;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.data.PomDependencyMgt;
import org.gradle.api.internal.artifacts.metadata.DefaultMavenModuleVersionMetaData;
import org.gradle.api.internal.artifacts.metadata.MutableModuleVersionMetaData;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.resource.LocallyAvailableExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GradlePomModuleDescriptorParser
extends AbstractModuleDescriptorParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(GradlePomModuleDescriptorParser.class);
    private static final String DEPENDENCY_IMPORT_SCOPE = "import";

    @Override
    protected String getTypeName() {
        return "POM";
    }

    public String toString() {
        return "gradle pom parser";
    }

    @Override
    protected MutableModuleVersionMetaData doParseDescriptor(DescriptorParseContext parserSettings, LocallyAvailableExternalResource resource, boolean validate) throws IOException, ParseException, SAXException {
        PomReader pomReader = new PomReader(resource);
        GradlePomModuleDescriptorBuilder mdBuilder = new GradlePomModuleDescriptorBuilder(pomReader);
        this.doParsePom(parserSettings, mdBuilder, pomReader);
        DefaultModuleDescriptor moduleDescriptor = mdBuilder.getModuleDescriptor();
        if (pomReader.getRelocation() != null) {
            return new DefaultMavenModuleVersionMetaData((ModuleDescriptor)moduleDescriptor, "pom", true);
        }
        return new DefaultMavenModuleVersionMetaData((ModuleDescriptor)moduleDescriptor, pomReader.getPackaging(), false);
    }

    private void doParsePom(DescriptorParseContext parserSettings, GradlePomModuleDescriptorBuilder mdBuilder, PomReader pomReader) throws IOException, SAXException {
        if (pomReader.hasParent()) {
            ModuleVersionIdentifier parentId = DefaultModuleVersionIdentifier.newId(pomReader.getParentGroupId(), pomReader.getParentArtifactId(), pomReader.getParentVersion());
            PomReader parentPomReader = this.parseOtherPom(parserSettings, parentId);
            pomReader.setPomParent(parentPomReader);
        }
        pomReader.resolveGAV();
        String groupId = pomReader.getGroupId();
        String artifactId = pomReader.getArtifactId();
        String version = pomReader.getVersion();
        mdBuilder.setModuleRevId(groupId, artifactId, version);
        mdBuilder.setHomePage(pomReader.getHomePage());
        mdBuilder.setDescription(pomReader.getDescription());
        mdBuilder.setLicenses(pomReader.getLicenses());
        ModuleRevisionId relocation = pomReader.getRelocation();
        if (relocation != null) {
            if (groupId != null && artifactId != null && artifactId.equals(relocation.getName()) && groupId.equals(relocation.getOrganisation())) {
                LOGGER.error("POM relocation to an other version number is not fully supported in Gradle : {} relocated to {}.", (Object)mdBuilder.getModuleDescriptor().getModuleRevisionId(), (Object)relocation);
                LOGGER.warn("Please update your dependency to directly use the correct version '{}'.", (Object)relocation);
                LOGGER.warn("Resolution will only pick dependencies of the relocated element.  Artifacts and other metadata will be ignored.");
                PomReader relocatedModule = this.parseOtherPom(parserSettings, DefaultModuleVersionIdentifier.newId(relocation));
                Collection<PomReader.PomDependencyData> pomDependencyDataList = relocatedModule.getDependencies().values();
                for (PomReader.PomDependencyData pomDependencyData : pomDependencyDataList) {
                    mdBuilder.addDependency(pomDependencyData);
                }
            } else {
                Configuration[] m2Confs;
                LOGGER.info(mdBuilder.getModuleDescriptor().getModuleRevisionId() + " is relocated to " + relocation + ". Please update your dependencies.");
                LOGGER.debug("Relocated module will be considered as a dependency");
                DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor((ModuleDescriptor)mdBuilder.getModuleDescriptor(), relocation, true, false, true);
                for (Configuration m2Conf : m2Confs = GradlePomModuleDescriptorBuilder.MAVEN2_CONFIGURATIONS) {
                    if (!Configuration.Visibility.PUBLIC.equals(m2Conf.getVisibility())) continue;
                    dd.addDependencyConfiguration(m2Conf.getName(), m2Conf.getName());
                }
                mdBuilder.addDependency((DependencyDescriptor)dd);
            }
        } else {
            this.overrideDependencyMgtsWithImported(parserSettings, pomReader);
            for (PomReader.PomDependencyData dependency : pomReader.getDependencies().values()) {
                mdBuilder.addDependency(dependency);
            }
        }
    }

    private void overrideDependencyMgtsWithImported(DescriptorParseContext parseContext, PomReader pomReader) throws IOException, SAXException {
        Map<MavenDependencyKey, PomDependencyMgt> importedDependencyMgts = this.parseImportedDependencyMgts(parseContext, pomReader.parseDependencyMgt());
        pomReader.addImportedDependencyMgts(importedDependencyMgts);
    }

    private Map<MavenDependencyKey, PomDependencyMgt> parseImportedDependencyMgts(DescriptorParseContext parseContext, Collection<PomDependencyMgt> currentDependencyMgts) throws IOException, SAXException {
        LinkedHashMap<MavenDependencyKey, PomDependencyMgt> importedDependencyMgts = new LinkedHashMap<MavenDependencyKey, PomDependencyMgt>();
        for (PomDependencyMgt currentDependencyMgt : currentDependencyMgts) {
            if (!this.isDependencyImportScoped(currentDependencyMgt)) continue;
            PomReader importDescr = this.parseImportedPom(parseContext, currentDependencyMgt);
            importedDependencyMgts.putAll(importDescr.getDependencyMgt());
        }
        return importedDependencyMgts;
    }

    private boolean isDependencyImportScoped(PomDependencyMgt dependencyMgt) {
        return DEPENDENCY_IMPORT_SCOPE.equals(dependencyMgt.getScope());
    }

    private PomReader parseImportedPom(DescriptorParseContext parseContext, PomDependencyMgt pomDependencyMgt) throws IOException, SAXException {
        ModuleVersionIdentifier importedId = DefaultModuleVersionIdentifier.newId(pomDependencyMgt.getGroupId(), pomDependencyMgt.getArtifactId(), pomDependencyMgt.getVersion());
        return this.parseOtherPom(parseContext, importedId);
    }

    private PomReader parseOtherPom(DescriptorParseContext parseContext, ModuleVersionIdentifier parentId) throws IOException, SAXException {
        LocallyAvailableExternalResource localResource = parseContext.getMetaDataArtifact(parentId, ArtifactType.MAVEN_POM);
        PomReader pomReader = new PomReader(localResource);
        GradlePomModuleDescriptorBuilder mdBuilder = new GradlePomModuleDescriptorBuilder(pomReader);
        this.doParsePom(parseContext, mdBuilder, pomReader);
        return pomReader;
    }
}

