/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.gradle.api.internal.artifacts.ivyservice.IvyUtil;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.PomReader;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.UnresolvedDependencyVersionException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.data.PomDependencyMgt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradlePomModuleDescriptorBuilder {
    public static final Configuration[] MAVEN2_CONFIGURATIONS = new Configuration[]{new Configuration("default", Configuration.Visibility.PUBLIC, "runtime dependencies and master artifact can be used with this conf", new String[]{"runtime", "master"}, true, null), new Configuration("master", Configuration.Visibility.PUBLIC, "contains only the artifact published by this module itself, with no transitive dependencies", new String[0], true, null), new Configuration("compile", Configuration.Visibility.PUBLIC, "this is the default scope, used if none is specified. Compile dependencies are available in all classpaths.", new String[0], true, null), new Configuration("provided", Configuration.Visibility.PUBLIC, "this is much like compile, but indicates you expect the JDK or a container to provide it. It is only available on the compilation classpath, and is not transitive.", new String[0], true, null), new Configuration("runtime", Configuration.Visibility.PUBLIC, "this scope indicates that the dependency is not required for compilation, but is for execution. It is in the runtime and test classpaths, but not the compile classpath.", new String[]{"compile"}, true, null), new Configuration("test", Configuration.Visibility.PRIVATE, "this scope indicates that the dependency is not required for normal use of the application, and is only available for the test compilation and execution phases.", new String[]{"runtime"}, true, null), new Configuration("system", Configuration.Visibility.PUBLIC, "this scope is similar to provided except that you have to provide the JAR which contains it explicitly. The artifact is always available and is not looked up in a repository.", new String[0], true, null), new Configuration("sources", Configuration.Visibility.PUBLIC, "this configuration contains the source artifact of this module, if any.", new String[0], true, null), new Configuration("javadoc", Configuration.Visibility.PUBLIC, "this configuration contains the javadoc artifact of this module, if any.", new String[0], true, null), new Configuration("optional", Configuration.Visibility.PUBLIC, "contains all optional dependencies", new String[0], true, null)};
    static final Map<String, ConfMapper> MAVEN2_CONF_MAPPING = new HashMap<String, ConfMapper>();
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("(.+)-\\d{8}\\.\\d{6}-\\d+");
    private static final String EXTRA_ATTRIBUTE_CLASSIFIER = "m:classifier";
    private final DefaultModuleDescriptor ivyModuleDescriptor = new DefaultModuleDescriptor((ModuleDescriptorParser)XmlModuleDescriptorParser.getInstance(), null);
    private ModuleRevisionId mrid;
    private final PomReader pomReader;

    public GradlePomModuleDescriptorBuilder(PomReader pomReader) {
        this.ivyModuleDescriptor.setResolvedPublicationDate(new Date());
        for (Configuration maven2Configuration : MAVEN2_CONFIGURATIONS) {
            this.ivyModuleDescriptor.addConfiguration(maven2Configuration);
        }
        this.ivyModuleDescriptor.setMappingOverride(true);
        this.ivyModuleDescriptor.addExtraAttributeNamespace("m", Ivy.getIvyHomeURL() + "maven");
        this.pomReader = pomReader;
    }

    public DefaultModuleDescriptor getModuleDescriptor() {
        return this.ivyModuleDescriptor;
    }

    public void setModuleRevId(String group, String module, String version) {
        Matcher matcher;
        String effectiveVersion = version;
        if (version != null && (matcher = TIMESTAMP_PATTERN.matcher(version)).matches()) {
            effectiveVersion = matcher.group(1) + "-SNAPSHOT";
        }
        this.mrid = ModuleRevisionId.newInstance((String)group, (String)module, (String)effectiveVersion);
        this.ivyModuleDescriptor.setModuleRevisionId(this.mrid);
        if (effectiveVersion != null && effectiveVersion.endsWith("SNAPSHOT")) {
            this.ivyModuleDescriptor.setStatus("integration");
        } else {
            this.ivyModuleDescriptor.setStatus("release");
        }
    }

    public void setHomePage(String homePage) {
        this.ivyModuleDescriptor.setHomePage(homePage);
    }

    public void setDescription(String description) {
        this.ivyModuleDescriptor.setDescription(description);
    }

    public void setLicenses(Iterable<License> licenses) {
        for (License license : licenses) {
            this.ivyModuleDescriptor.addLicense(license);
        }
    }

    public void addDependency(PomReader.PomDependencyData dep) {
        List<ModuleId> excluded;
        boolean hasNonJarType;
        String scope = dep.getScope();
        if (scope != null && scope.length() > 0 && !MAVEN2_CONF_MAPPING.containsKey(scope)) {
            scope = "compile";
        }
        String version = this.determineVersion(dep);
        ModuleRevisionId moduleRevId = IvyUtil.createModuleRevisionId(dep.getGroupId(), dep.getArtifactId(), version);
        ModuleRevisionId mRevId = this.ivyModuleDescriptor.getModuleRevisionId();
        if (mRevId != null && mRevId.getModuleId().equals((Object)moduleRevId.getModuleId())) {
            return;
        }
        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor((ModuleDescriptor)this.ivyModuleDescriptor, moduleRevId, true, false, true);
        scope = scope == null || scope.length() == 0 ? this.getDefaultScope(dep) : scope;
        ConfMapper mapping = MAVEN2_CONF_MAPPING.get(scope);
        mapping.addMappingConfs(dd, dep.isOptional());
        HashMap<String, String> extraAtt = new HashMap<String, String>();
        boolean hasClassifier = dep.getClassifier() != null && dep.getClassifier().length() > 0;
        boolean bl = hasNonJarType = dep.getType() != null && !"jar".equals(dep.getType());
        if (hasClassifier || hasNonJarType) {
            String type = "jar";
            if (dep.getType() != null) {
                type = dep.getType();
            }
            String ext = this.determineExtension(type);
            this.handleSpecialTypes(type, extraAtt);
            if (dep.getClassifier() != null) {
                extraAtt.put(EXTRA_ATTRIBUTE_CLASSIFIER, dep.getClassifier());
            }
            DefaultDependencyArtifactDescriptor depArtifact = new DefaultDependencyArtifactDescriptor((DependencyDescriptor)dd, dd.getDependencyId().getName(), type, ext, null, extraAtt);
            String optionalizedScope = dep.isOptional() ? "optional" : scope;
            dd.addDependencyArtifact(optionalizedScope, (DependencyArtifactDescriptor)depArtifact);
        }
        if ((excluded = dep.getExcludedModules()).isEmpty()) {
            excluded = this.getDependencyMgtExclusions(dep);
        }
        Iterator<ModuleId> i$ = excluded.iterator();
        while (i$.hasNext()) {
            String[] confs;
            ModuleId anExcluded;
            ModuleId excludedModule = anExcluded = i$.next();
            for (String conf : confs = dd.getModuleConfigurations()) {
                dd.addExcludeRule(conf, (ExcludeRule)new DefaultExcludeRule(new ArtifactId(excludedModule, "*", "*", "*"), (PatternMatcher)ExactPatternMatcher.INSTANCE, null));
            }
        }
        this.ivyModuleDescriptor.addDependency((DependencyDescriptor)dd);
    }

    private String determineExtension(String type) {
        return JarDependencyType.isJarExtension(type) ? "jar" : type;
    }

    private void handleSpecialTypes(String type, Map<String, String> extraAttributes) {
        if (JarDependencyType.TEST_JAR.getName().equals(type)) {
            extraAttributes.put(EXTRA_ATTRIBUTE_CLASSIFIER, "tests");
        } else if (JarDependencyType.EJB_CLIENT.getName().equals(type)) {
            extraAttributes.put(EXTRA_ATTRIBUTE_CLASSIFIER, "client");
        }
    }

    private String determineVersion(PomReader.PomDependencyData dependency) {
        String version = dependency.getVersion();
        String string = version = version == null || version.length() == 0 ? this.getDefaultVersion(dependency) : version;
        if (version == null) {
            throw new UnresolvedDependencyVersionException(dependency.getId());
        }
        return version;
    }

    public void addDependency(DependencyDescriptor descriptor) {
        ModuleId dependencyId = descriptor.getDependencyId();
        ModuleRevisionId mRevId = this.ivyModuleDescriptor.getModuleRevisionId();
        if (mRevId != null && mRevId.getModuleId().equals((Object)dependencyId)) {
            return;
        }
        this.ivyModuleDescriptor.addDependency(descriptor);
    }

    private String getDefaultVersion(PomReader.PomDependencyData dep) {
        PomDependencyMgt pomDependencyMgt = this.findDependencyDefault(dep);
        if (pomDependencyMgt != null) {
            return pomDependencyMgt.getVersion();
        }
        return null;
    }

    private String getDefaultScope(PomReader.PomDependencyData dep) {
        PomDependencyMgt pomDependencyMgt = this.findDependencyDefault(dep);
        String result = null;
        if (pomDependencyMgt != null) {
            result = pomDependencyMgt.getScope();
        }
        if (result == null || !MAVEN2_CONF_MAPPING.containsKey(result)) {
            result = "compile";
        }
        return result;
    }

    private List<ModuleId> getDependencyMgtExclusions(PomReader.PomDependencyData dep) {
        PomDependencyMgt pomDependencyMgt = this.findDependencyDefault(dep);
        if (pomDependencyMgt != null) {
            return pomDependencyMgt.getExcludedModules();
        }
        return Collections.emptyList();
    }

    private PomDependencyMgt findDependencyDefault(PomReader.PomDependencyData dependency) {
        return this.pomReader.findDependencyDefaults(dependency.getId());
    }

    static {
        MAVEN2_CONF_MAPPING.put("compile", new ConfMapper(){

            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                if (isOptional) {
                    dd.addDependencyConfiguration("optional", "compile(*)");
                    dd.addDependencyConfiguration("optional", "master(*)");
                } else {
                    dd.addDependencyConfiguration("compile", "compile(*)");
                    dd.addDependencyConfiguration("compile", "master(*)");
                    dd.addDependencyConfiguration("runtime", "runtime(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("provided", new ConfMapper(){

            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                if (isOptional) {
                    dd.addDependencyConfiguration("optional", "compile(*)");
                    dd.addDependencyConfiguration("optional", "provided(*)");
                    dd.addDependencyConfiguration("optional", "runtime(*)");
                    dd.addDependencyConfiguration("optional", "master(*)");
                } else {
                    dd.addDependencyConfiguration("provided", "compile(*)");
                    dd.addDependencyConfiguration("provided", "provided(*)");
                    dd.addDependencyConfiguration("provided", "runtime(*)");
                    dd.addDependencyConfiguration("provided", "master(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("runtime", new ConfMapper(){

            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                if (isOptional) {
                    dd.addDependencyConfiguration("optional", "compile(*)");
                    dd.addDependencyConfiguration("optional", "provided(*)");
                    dd.addDependencyConfiguration("optional", "master(*)");
                } else {
                    dd.addDependencyConfiguration("runtime", "compile(*)");
                    dd.addDependencyConfiguration("runtime", "runtime(*)");
                    dd.addDependencyConfiguration("runtime", "master(*)");
                }
            }
        });
        MAVEN2_CONF_MAPPING.put("test", new ConfMapper(){

            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                dd.addDependencyConfiguration("test", "runtime(*)");
                dd.addDependencyConfiguration("test", "master(*)");
            }
        });
        MAVEN2_CONF_MAPPING.put("system", new ConfMapper(){

            public void addMappingConfs(DefaultDependencyDescriptor dd, boolean isOptional) {
                dd.addDependencyConfiguration("system", "master(*)");
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JarDependencyType {
        TEST_JAR("test-jar"),
        EJB_CLIENT("ejb-client"),
        EJB("ejb"),
        BUNDLE("bundle"),
        MAVEN_PLUGIN("maven-plugin"),
        ECLIPSE_PLUGIN("eclipse-plugin");

        private static final Map<String, JarDependencyType> TYPES;
        private final String name;

        private JarDependencyType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static boolean isJarExtension(String type) {
            return TYPES.containsKey(type);
        }

        static {
            TYPES = new HashMap<String, JarDependencyType>();
            for (JarDependencyType type : JarDependencyType.values()) {
                TYPES.put(type.name, type);
            }
        }
    }

    static interface ConfMapper {
        public void addMappingConfs(DefaultDependencyDescriptor var1, boolean var2);
    }
}

