/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.artifacts.ivyservice.BuildableArtifactResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache.InMemoryCacheStats;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactIdentifier;

class InMemoryArtifactsCache {
    private final Map<ComponentArtifactIdentifier, File> artifacts = new HashMap<ComponentArtifactIdentifier, File>();
    private InMemoryCacheStats stats;

    InMemoryArtifactsCache(InMemoryCacheStats stats) {
        this.stats = stats;
    }

    public boolean supplyArtifact(ComponentArtifactIdentifier id, BuildableArtifactResolveResult result) {
        File fromCache = this.artifacts.get(id);
        if (fromCache != null) {
            result.resolved(fromCache);
            ++this.stats.artifactsServed;
            return true;
        }
        return false;
    }

    public void newArtifact(ComponentArtifactIdentifier id, BuildableArtifactResolveResult result) {
        if (result.hasResult() && result.getFailure() == null) {
            this.artifacts.put(id, result.getFile());
        }
    }
}

