/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache;

import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BuildableModuleVersionMetaDataResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleSource;
import org.gradle.api.internal.artifacts.metadata.MutableModuleVersionMetaData;

class CachedModuleVersionResult {
    private final BuildableModuleVersionMetaDataResolveResult.State state;
    private final MutableModuleVersionMetaData metaData;
    private final ModuleSource moduleSource;

    public CachedModuleVersionResult(BuildableModuleVersionMetaDataResolveResult result) {
        this.state = result.getState();
        if (this.state == BuildableModuleVersionMetaDataResolveResult.State.Resolved) {
            this.metaData = result.getMetaData().copy();
            this.moduleSource = result.getModuleSource();
        } else {
            this.metaData = null;
            this.moduleSource = null;
        }
    }

    public boolean isCacheable() {
        return this.state == BuildableModuleVersionMetaDataResolveResult.State.Missing || this.state == BuildableModuleVersionMetaDataResolveResult.State.ProbablyMissing || this.state == BuildableModuleVersionMetaDataResolveResult.State.Resolved;
    }

    public void supply(BuildableModuleVersionMetaDataResolveResult result) {
        assert (this.isCacheable()) : "Results are not cacheable, cannot supply the results.";
        if (this.state == BuildableModuleVersionMetaDataResolveResult.State.Resolved) {
            result.resolved(this.metaData.copy(), this.moduleSource);
        } else if (this.state == BuildableModuleVersionMetaDataResolveResult.State.Missing) {
            result.missing();
        } else if (this.state == BuildableModuleVersionMetaDataResolveResult.State.ProbablyMissing) {
            result.probablyMissing();
        }
    }
}

