/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.artifacts.cache.ResolutionRules;
import org.gradle.api.internal.artifacts.ModuleMetadataProcessor;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.CachePolicy;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactResolver;
import org.gradle.api.internal.artifacts.ivyservice.BuildableArtifactResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.BuildableArtifactSetResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.BuildableComponentResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.ComponentUsage;
import org.gradle.api.internal.artifacts.ivyservice.DependencyToModuleVersionResolver;
import org.gradle.api.internal.artifacts.ivyservice.dynamicversions.ModuleVersionsCache;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.CacheLockReleasingModuleComponentsRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.CachingModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.IvyDynamicResolveModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.LocalModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleSource;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChain;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.StartParameterResolutionOverride;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.UserResolverChain;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache.InMemoryCachedRepositoryFactory;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestStrategy;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionMatcher;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleArtifactsCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetaDataCache;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ComponentMetaData;
import org.gradle.api.internal.artifacts.metadata.DependencyMetaData;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolver;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.resource.cached.CachedArtifactIndex;
import org.gradle.util.BuildCommencedTimeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveIvyFactory {
    private final ModuleVersionsCache moduleVersionsCache;
    private final ModuleMetaDataCache moduleMetaDataCache;
    private final ModuleArtifactsCache moduleArtifactsCache;
    private final CachedArtifactIndex artifactAtRepositoryCachedResolutionIndex;
    private final CacheLockingManager cacheLockingManager;
    private final StartParameterResolutionOverride startParameterResolutionOverride;
    private final BuildCommencedTimeProvider timeProvider;
    private final InMemoryCachedRepositoryFactory inMemoryCache;
    private final VersionMatcher versionMatcher;
    private final LatestStrategy latestStrategy;

    public ResolveIvyFactory(ModuleVersionsCache moduleVersionsCache, ModuleMetaDataCache moduleMetaDataCache, ModuleArtifactsCache moduleArtifactsCache, CachedArtifactIndex artifactAtRepositoryCachedResolutionIndex, CacheLockingManager cacheLockingManager, StartParameterResolutionOverride startParameterResolutionOverride, BuildCommencedTimeProvider timeProvider, InMemoryCachedRepositoryFactory inMemoryCache, VersionMatcher versionMatcher, LatestStrategy latestStrategy) {
        this.moduleVersionsCache = moduleVersionsCache;
        this.moduleMetaDataCache = moduleMetaDataCache;
        this.moduleArtifactsCache = moduleArtifactsCache;
        this.artifactAtRepositoryCachedResolutionIndex = artifactAtRepositoryCachedResolutionIndex;
        this.cacheLockingManager = cacheLockingManager;
        this.startParameterResolutionOverride = startParameterResolutionOverride;
        this.timeProvider = timeProvider;
        this.inMemoryCache = inMemoryCache;
        this.versionMatcher = versionMatcher;
        this.latestStrategy = latestStrategy;
    }

    public RepositoryChain create(ConfigurationInternal configuration, Iterable<? extends ResolutionAwareRepository> repositories, ModuleMetadataProcessor metadataProcessor) {
        ResolutionRules resolutionRules = configuration.getResolutionStrategy().getResolutionRules();
        CachePolicy cachePolicy = configuration.getResolutionStrategy().getCachePolicy();
        this.startParameterResolutionOverride.addResolutionRules(resolutionRules);
        UserResolverChain userResolverChain = new UserResolverChain(this.versionMatcher, this.latestStrategy);
        ParentModuleLookupResolver parentLookupResolver = new ParentModuleLookupResolver(userResolverChain, this.cacheLockingManager);
        for (ResolutionAwareRepository resolutionAwareRepository : repositories) {
            ConfiguredModuleComponentRepository baseRepository = resolutionAwareRepository.createResolver();
            if (baseRepository instanceof ExternalResourceResolver) {
                ((ExternalResourceResolver)baseRepository).setRepositoryChain(parentLookupResolver);
            }
            ModuleComponentRepository moduleComponentRepository = baseRepository;
            if (baseRepository.isLocal()) {
                moduleComponentRepository = new LocalModuleComponentRepository(baseRepository, metadataProcessor);
            } else {
                moduleComponentRepository = new CacheLockReleasingModuleComponentsRepository(moduleComponentRepository, this.cacheLockingManager);
                moduleComponentRepository = this.startParameterResolutionOverride.overrideModuleVersionRepository(moduleComponentRepository);
                moduleComponentRepository = new CachingModuleComponentRepository(moduleComponentRepository, this.moduleVersionsCache, this.moduleMetaDataCache, this.moduleArtifactsCache, this.artifactAtRepositoryCachedResolutionIndex, cachePolicy, this.timeProvider, metadataProcessor);
            }
            if (baseRepository.isDynamicResolveMode()) {
                moduleComponentRepository = IvyDynamicResolveModuleComponentRepositoryAccess.wrap(moduleComponentRepository);
            }
            moduleComponentRepository = this.inMemoryCache.cached(moduleComponentRepository);
            userResolverChain.add(moduleComponentRepository);
        }
        return userResolverChain;
    }

    private static class ParentModuleLookupResolver
    implements RepositoryChain,
    DependencyToModuleVersionResolver,
    ArtifactResolver {
        private final DependencyToModuleVersionResolver dependencyResolver;
        private final ArtifactResolver artifactResolver;
        private final CacheLockingManager cacheLockingManager;

        public ParentModuleLookupResolver(RepositoryChain repositoryChain, CacheLockingManager cacheLockingManager) {
            this.dependencyResolver = repositoryChain.getDependencyResolver();
            this.artifactResolver = repositoryChain.getArtifactResolver();
            this.cacheLockingManager = cacheLockingManager;
        }

        public ArtifactResolver getArtifactResolver() {
            return this;
        }

        public DependencyToModuleVersionResolver getDependencyResolver() {
            return this;
        }

        public void resolve(final DependencyMetaData dependency, final BuildableComponentResolveResult result) {
            this.cacheLockingManager.useCache(String.format("Resolve %s", dependency), new Runnable(){

                public void run() {
                    ParentModuleLookupResolver.this.dependencyResolver.resolve(dependency, result);
                }
            });
        }

        public void resolveModuleArtifacts(final ComponentMetaData component, final ArtifactType artifactType, final BuildableArtifactSetResolveResult result) {
            this.cacheLockingManager.useCache(String.format("Resolve %s for %s", artifactType, component), new Runnable(){

                public void run() {
                    ParentModuleLookupResolver.this.artifactResolver.resolveModuleArtifacts(component, artifactType, result);
                }
            });
        }

        public void resolveModuleArtifacts(final ComponentMetaData component, final ComponentUsage usage, final BuildableArtifactSetResolveResult result) {
            this.cacheLockingManager.useCache(String.format("Resolve %s for %s", usage, component), new Runnable(){

                public void run() {
                    ParentModuleLookupResolver.this.artifactResolver.resolveModuleArtifacts(component, usage, result);
                }
            });
        }

        public void resolveArtifact(final ComponentArtifactMetaData artifact, final ModuleSource moduleSource, final BuildableArtifactResolveResult result) {
            this.cacheLockingManager.useCache(String.format("Resolve %s", artifact), new Runnable(){

                public void run() {
                    ParentModuleLookupResolver.this.artifactResolver.resolveArtifact(artifact, moduleSource, result);
                }
            });
        }
    }
}

