/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Collections;
import java.util.List;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.component.DefaultModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentChooser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.DefaultBuildableModuleVersionMetaDataResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleVersionListing;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.VersionInfo;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.Versioned;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestStrategy;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionMatcher;
import org.gradle.api.internal.artifacts.metadata.ComponentMetaData;
import org.gradle.api.internal.artifacts.metadata.DependencyMetaData;
import org.gradle.api.internal.artifacts.metadata.MutableModuleVersionMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NewestVersionComponentChooser
implements ComponentChooser {
    private final VersionMatcher versionMatcher;
    private final LatestStrategy latestStrategy;

    NewestVersionComponentChooser(LatestStrategy latestStrategy, VersionMatcher versionMatcher) {
        this.latestStrategy = latestStrategy;
        this.versionMatcher = versionMatcher;
    }

    @Override
    public boolean canSelectMultipleComponents(ModuleVersionSelector selector) {
        return this.versionMatcher.isDynamic(selector.getVersion());
    }

    @Override
    public ComponentMetaData choose(ComponentMetaData one, ComponentMetaData two) {
        if (one == null || two == null) {
            return two == null ? one : two;
        }
        int comparison = this.latestStrategy.compare(new VersionInfo(one.getId().getVersion()), new VersionInfo(two.getId().getVersion()));
        if (comparison == 0) {
            if (this.isGeneratedModuleDescriptor(one) && !this.isGeneratedModuleDescriptor(two)) {
                return two;
            }
            return one;
        }
        return comparison < 0 ? two : one;
    }

    private boolean isGeneratedModuleDescriptor(ComponentMetaData componentMetaData) {
        return componentMetaData.isGenerated();
    }

    @Override
    public ModuleComponentIdentifier choose(ModuleVersionListing versions, DependencyMetaData dependency, ModuleComponentRepositoryAccess moduleAccess) {
        if (this.versionMatcher.needModuleMetadata(dependency.getRequested().getVersion())) {
            return this.chooseBestMatchingDependencyWithMetaData(versions, dependency, moduleAccess);
        }
        return this.chooseBestMatchingDependency(versions, dependency.getRequested());
    }

    private ModuleComponentIdentifier chooseBestMatchingDependency(ModuleVersionListing versions, ModuleVersionSelector requested) {
        for (Versioned candidate : this.sortLatestFirst(versions)) {
            if (!this.versionMatcher.accept(requested.getVersion(), candidate.getVersion())) continue;
            return DefaultModuleComponentIdentifier.newId(requested.getGroup(), requested.getName(), candidate.getVersion());
        }
        return null;
    }

    private ModuleComponentIdentifier chooseBestMatchingDependencyWithMetaData(ModuleVersionListing versions, DependencyMetaData dependency, ModuleComponentRepositoryAccess moduleAccess) {
        for (Versioned candidate : this.sortLatestFirst(versions)) {
            MutableModuleVersionMetaData metaData = this.resolveComponentMetaData(dependency, candidate, moduleAccess);
            if (!this.versionMatcher.accept(dependency.getRequested().getVersion(), metaData)) continue;
            return metaData.getComponentId();
        }
        return null;
    }

    private MutableModuleVersionMetaData resolveComponentMetaData(DependencyMetaData dependency, Versioned candidate, ModuleComponentRepositoryAccess moduleAccess) {
        ModuleVersionSelector selector = dependency.getRequested();
        ModuleComponentIdentifier candidateId = DefaultModuleComponentIdentifier.newId(selector.getGroup(), selector.getName(), candidate.getVersion());
        DependencyMetaData moduleVersionDependency = dependency.withRequestedVersion(candidate.getVersion());
        DefaultBuildableModuleVersionMetaDataResolveResult descriptorResult = new DefaultBuildableModuleVersionMetaDataResolveResult();
        moduleAccess.resolveComponentMetaData(moduleVersionDependency, candidateId, descriptorResult);
        return descriptorResult.getMetaData();
    }

    private List<Versioned> sortLatestFirst(ModuleVersionListing listing) {
        List<Versioned> sorted = this.latestStrategy.sort(listing.getVersions());
        Collections.reverse(sorted);
        return sorted;
    }
}

