/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ModuleMetadataProcessor;
import org.gradle.api.internal.artifacts.ivyservice.BuildableArtifactResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.BuildableArtifactSetResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ComponentUsage;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BaseModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BuildableModuleVersionMetaDataResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BuildableModuleVersionSelectionResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleSource;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ComponentMetaData;
import org.gradle.api.internal.artifacts.metadata.DependencyMetaData;
import org.gradle.api.internal.component.ArtifactType;

public class LocalModuleComponentRepository
extends BaseModuleComponentRepository {
    private final ModuleMetadataProcessor processor;
    private final LocalAccess localAccess = new LocalAccess();
    private final RemoteAccess remoteAccess = new RemoteAccess();

    public LocalModuleComponentRepository(ModuleComponentRepository delegate, ModuleMetadataProcessor processor) {
        super(delegate);
        this.processor = processor;
    }

    public ModuleComponentRepositoryAccess getLocalAccess() {
        return this.localAccess;
    }

    public ModuleComponentRepositoryAccess getRemoteAccess() {
        return this.remoteAccess;
    }

    private static class RemoteAccess
    implements ModuleComponentRepositoryAccess {
        private RemoteAccess() {
        }

        public void listModuleVersions(DependencyMetaData dependency, BuildableModuleVersionSelectionResolveResult result) {
        }

        public void resolveComponentMetaData(DependencyMetaData dependency, ModuleComponentIdentifier moduleComponentIdentifier, BuildableModuleVersionMetaDataResolveResult result) {
        }

        public void resolveModuleArtifacts(ComponentMetaData component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
        }

        public void resolveModuleArtifacts(ComponentMetaData component, ComponentUsage componentUsage, BuildableArtifactSetResolveResult result) {
        }

        public void resolveArtifact(ComponentArtifactMetaData artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
        }
    }

    private class LocalAccess
    implements ModuleComponentRepositoryAccess {
        private LocalAccess() {
        }

        public void listModuleVersions(DependencyMetaData dependency, BuildableModuleVersionSelectionResolveResult result) {
            LocalModuleComponentRepository.this.delegate.getLocalAccess().listModuleVersions(dependency, result);
            if (!result.hasResult()) {
                LocalModuleComponentRepository.this.delegate.getRemoteAccess().listModuleVersions(dependency, result);
            }
        }

        public void resolveComponentMetaData(DependencyMetaData dependency, ModuleComponentIdentifier moduleComponentIdentifier, BuildableModuleVersionMetaDataResolveResult result) {
            LocalModuleComponentRepository.this.delegate.getLocalAccess().resolveComponentMetaData(dependency, moduleComponentIdentifier, result);
            if (!result.hasResult()) {
                LocalModuleComponentRepository.this.delegate.getRemoteAccess().resolveComponentMetaData(dependency, moduleComponentIdentifier, result);
            }
            if (result.getState() == BuildableModuleVersionMetaDataResolveResult.State.Resolved) {
                LocalModuleComponentRepository.this.processor.process(result.getMetaData());
            }
        }

        public void resolveModuleArtifacts(ComponentMetaData component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            LocalModuleComponentRepository.this.delegate.getLocalAccess().resolveModuleArtifacts(component, artifactType, result);
            if (!result.hasResult()) {
                LocalModuleComponentRepository.this.delegate.getRemoteAccess().resolveModuleArtifacts(component, artifactType, result);
            }
        }

        public void resolveModuleArtifacts(ComponentMetaData component, ComponentUsage componentUsage, BuildableArtifactSetResolveResult result) {
            LocalModuleComponentRepository.this.delegate.getLocalAccess().resolveModuleArtifacts(component, componentUsage, result);
            if (!result.hasResult()) {
                LocalModuleComponentRepository.this.delegate.getRemoteAccess().resolveModuleArtifacts(component, componentUsage, result);
            }
        }

        public void resolveArtifact(ComponentArtifactMetaData artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
            LocalModuleComponentRepository.this.delegate.getLocalAccess().resolveArtifact(artifact, moduleSource, result);
            if (!result.hasResult()) {
                LocalModuleComponentRepository.this.delegate.getRemoteAccess().resolveArtifact(artifact, moduleSource, result);
            }
        }
    }
}

