/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ComponentResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.DefaultBuildableComponentResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.DependencyToModuleVersionIdResolver;
import org.gradle.api.internal.artifacts.ivyservice.DependencyToModuleVersionResolver;
import org.gradle.api.internal.artifacts.ivyservice.ModuleVersionIdResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ModuleVersionResolveException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionMatcher;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.api.internal.artifacts.metadata.ComponentMetaData;
import org.gradle.api.internal.artifacts.metadata.DependencyMetaData;

public class LazyDependencyToModuleResolver
implements DependencyToModuleVersionIdResolver {
    private final DependencyToModuleVersionResolver dependencyResolver;
    private final VersionMatcher versionMatcher;

    public LazyDependencyToModuleResolver(DependencyToModuleVersionResolver dependencyResolver, VersionMatcher versionMatcher) {
        this.dependencyResolver = dependencyResolver;
        this.versionMatcher = versionMatcher;
    }

    public ModuleVersionIdResolveResult resolve(DependencyMetaData dependency) {
        if (this.versionMatcher.isDynamic(dependency.getRequested().getVersion())) {
            DynamicVersionResolveResult result = new DynamicVersionResolveResult(dependency);
            result.resolve();
            return result;
        }
        return new StaticVersionResolveResult(dependency);
    }

    private class DynamicVersionResolveResult
    extends AbstractVersionResolveResult {
        public DynamicVersionResolveResult(DependencyMetaData dependency) {
            super(dependency);
        }

        public ModuleVersionResolveException getFailure() {
            return this.resolve().getFailure();
        }

        public ModuleVersionIdentifier getId() throws ModuleVersionResolveException {
            return this.resolve().getId();
        }
    }

    private class StaticVersionResolveResult
    extends AbstractVersionResolveResult {
        private final ModuleVersionIdentifier id;

        public StaticVersionResolveResult(DependencyMetaData dependency) {
            super(dependency);
            ModuleVersionSelector requested = dependency.getRequested();
            this.id = new DefaultModuleVersionIdentifier(requested.getGroup(), requested.getName(), requested.getVersion());
        }

        public ModuleVersionIdentifier getId() throws ModuleVersionResolveException {
            return this.id;
        }

        public ComponentSelectionReason getSelectionReason() {
            return VersionSelectionReasons.REQUESTED;
        }

        protected void checkDescriptor(ComponentMetaData metaData) {
            if (!this.id.equals(metaData.getId())) {
                throw new ModuleVersionResolveException(this.dependency.getRequested(), String.format("Received unexpected module descriptor %s for dependency %%s.", metaData.getId()));
            }
            super.checkDescriptor(metaData);
        }
    }

    private abstract class AbstractVersionResolveResult
    implements ModuleVersionIdResolveResult {
        final DependencyMetaData dependency;
        private DefaultBuildableComponentResolveResult resolveResult;

        public AbstractVersionResolveResult(DependencyMetaData dependency) {
            this.dependency = dependency;
        }

        public ModuleVersionResolveException getFailure() {
            return null;
        }

        public ComponentResolveResult resolve() {
            if (this.resolveResult == null) {
                this.resolveResult = new DefaultBuildableComponentResolveResult();
                try {
                    try {
                        LazyDependencyToModuleResolver.this.dependencyResolver.resolve(this.dependency, this.resolveResult);
                    }
                    catch (Throwable t) {
                        throw new ModuleVersionResolveException(this.dependency.getRequested(), t);
                    }
                    if (this.resolveResult.getFailure() != null) {
                        throw this.resolveResult.getFailure();
                    }
                    this.checkDescriptor(this.resolveResult.getMetaData());
                }
                catch (ModuleVersionResolveException e) {
                    this.resolveResult.failed(e);
                }
            }
            return this.resolveResult;
        }

        public ComponentSelectionReason getSelectionReason() {
            return VersionSelectionReasons.REQUESTED;
        }

        public ModuleIdentifier getPreferredTarget() {
            return null;
        }

        protected void checkDescriptor(ComponentMetaData metaData) {
        }
    }
}

