/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Collection;
import org.gradle.api.internal.artifacts.ivyservice.DefaultResourceAwareResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ModuleVersionResolveException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BuildableModuleVersionSelectionResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.DefaultModuleVersionListing;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleVersionListing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildableModuleVersionSelectionResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableModuleVersionSelectionResolveResult {
    private BuildableModuleVersionSelectionResolveResult.State state = BuildableModuleVersionSelectionResolveResult.State.Unknown;
    private ModuleVersionResolveException failure;
    private ModuleVersionListing versions;

    private void reset(BuildableModuleVersionSelectionResolveResult.State state) {
        this.state = state;
        this.versions = null;
        this.failure = null;
    }

    @Override
    public BuildableModuleVersionSelectionResolveResult.State getState() {
        return this.state;
    }

    @Override
    public boolean hasResult() {
        return this.state != BuildableModuleVersionSelectionResolveResult.State.Unknown;
    }

    @Override
    public ModuleVersionListing getVersions() throws ModuleVersionResolveException {
        this.assertHasResult();
        return this.versions;
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    @Override
    public void listed(ModuleVersionListing versions) {
        this.reset(BuildableModuleVersionSelectionResolveResult.State.Listed);
        this.versions = versions;
    }

    @Override
    public void listed(Collection<String> versions) {
        DefaultModuleVersionListing listing = new DefaultModuleVersionListing();
        for (String version : versions) {
            listing.add(version);
        }
        this.listed(listing);
    }

    @Override
    public void probablyListed(ModuleVersionListing versions) {
        this.reset(BuildableModuleVersionSelectionResolveResult.State.ProbablyListed);
        this.versions = versions;
    }

    @Override
    public void failed(ModuleVersionResolveException failure) {
        this.reset(BuildableModuleVersionSelectionResolveResult.State.Failed);
        this.failure = failure;
    }

    private void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }
}

