/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.BuildableArtifactResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.BuildableArtifactSetResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.ComponentUsage;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BaseModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BuildableModuleVersionMetaDataResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BuildableModuleVersionSelectionResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleSource;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactMetaData;
import org.gradle.api.internal.artifacts.metadata.ComponentMetaData;
import org.gradle.api.internal.artifacts.metadata.DependencyMetaData;
import org.gradle.api.internal.component.ArtifactType;

public class CacheLockReleasingModuleComponentsRepository
extends BaseModuleComponentRepository {
    private final ModuleComponentRepositoryAccess remoteAccess;

    public CacheLockReleasingModuleComponentsRepository(ModuleComponentRepository repository, CacheLockingManager cacheLockingManager) {
        super(repository);
        this.remoteAccess = new LockReleasingRepositoryAccess(repository.getName(), repository.getRemoteAccess(), cacheLockingManager);
    }

    public ModuleComponentRepositoryAccess getRemoteAccess() {
        return this.remoteAccess;
    }

    private static class LockReleasingRepositoryAccess
    implements ModuleComponentRepositoryAccess {
        private final String name;
        private final ModuleComponentRepositoryAccess delegate;
        private final CacheLockingManager cacheLockingManager;

        private LockReleasingRepositoryAccess(String name, ModuleComponentRepositoryAccess delegate, CacheLockingManager cacheLockingManager) {
            this.name = name;
            this.delegate = delegate;
            this.cacheLockingManager = cacheLockingManager;
        }

        public void listModuleVersions(final DependencyMetaData dependency, final BuildableModuleVersionSelectionResolveResult result) {
            this.cacheLockingManager.longRunningOperation(String.format("List %s using repository %s", dependency, this.name), new Runnable(){

                public void run() {
                    LockReleasingRepositoryAccess.this.delegate.listModuleVersions(dependency, result);
                }
            });
        }

        public void resolveComponentMetaData(final DependencyMetaData dependency, final ModuleComponentIdentifier moduleComponentIdentifier, final BuildableModuleVersionMetaDataResolveResult result) {
            this.cacheLockingManager.longRunningOperation(String.format("Resolve %s using repository %s", dependency, this.name), new Runnable(){

                public void run() {
                    LockReleasingRepositoryAccess.this.delegate.resolveComponentMetaData(dependency, moduleComponentIdentifier, result);
                }
            });
        }

        public void resolveModuleArtifacts(final ComponentMetaData component, final ArtifactType artifactType, final BuildableArtifactSetResolveResult result) {
            this.cacheLockingManager.longRunningOperation(String.format("Resolve %s for %s using repository %s", artifactType, component, this.name), new Runnable(){

                public void run() {
                    LockReleasingRepositoryAccess.this.delegate.resolveModuleArtifacts(component, artifactType, result);
                }
            });
        }

        public void resolveModuleArtifacts(final ComponentMetaData component, final ComponentUsage componentUsage, final BuildableArtifactSetResolveResult result) {
            this.cacheLockingManager.longRunningOperation(String.format("Resolve %s for %s using repository %s", componentUsage, component, this.name), new Runnable(){

                public void run() {
                    LockReleasingRepositoryAccess.this.delegate.resolveModuleArtifacts(component, componentUsage, result);
                }
            });
        }

        public void resolveArtifact(final ComponentArtifactMetaData artifact, final ModuleSource moduleSource, final BuildableArtifactResolveResult result) {
            this.cacheLockingManager.longRunningOperation(String.format("Download %s using repository %s", artifact, this.name), new Runnable(){

                public void run() {
                    LockReleasingRepositoryAccess.this.delegate.resolveArtifact(artifact, moduleSource, result);
                }
            });
        }
    }
}

