/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.GradleException;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactIdentifier;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.util.GUtil;

@Contextual
public class ArtifactResolveException
extends GradleException {
    public ArtifactResolveException(String message) {
        super(message);
    }

    public ArtifactResolveException(String message, Throwable cause) {
        super(message, cause);
    }

    public ArtifactResolveException(ComponentIdentifier component, Throwable cause) {
        super(ArtifactResolveException.format(component, ""), cause);
    }

    public ArtifactResolveException(ComponentIdentifier component, String message) {
        super(ArtifactResolveException.format(component, message));
    }

    public ArtifactResolveException(ComponentArtifactIdentifier artifact, Throwable cause) {
        super(ArtifactResolveException.format(artifact, ""), cause);
    }

    public ArtifactResolveException(ComponentArtifactIdentifier artifact, String message) {
        super(ArtifactResolveException.format(artifact, message));
    }

    private static String format(ComponentArtifactIdentifier artifact, String message) {
        StringBuilder builder = new StringBuilder();
        builder.append("Could not download artifact '");
        builder.append(artifact.getDisplayName());
        builder.append("'");
        if (GUtil.isTrue((Object)message)) {
            builder.append(": ");
            builder.append(message);
        }
        return builder.toString();
    }

    private static String format(ComponentIdentifier component, String message) {
        StringBuilder builder = new StringBuilder();
        builder.append("Could not determine artifacts for component '");
        builder.append(component.getDisplayName());
        builder.append("'");
        if (GUtil.isTrue((Object)message)) {
            builder.append(": ");
            builder.append(message);
        }
        return builder.toString();
    }
}

