/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ArtifactResolveException;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactNotFoundException
extends ArtifactResolveException {
    public ArtifactNotFoundException(ComponentArtifactIdentifier artifact, List<String> attemptedLocations) {
        super(ArtifactNotFoundException.format(artifact, attemptedLocations));
    }

    private static String format(ComponentArtifactIdentifier artifact, List<String> locations) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Artifact '%s' not found.", artifact.getDisplayName()));
        if (!locations.isEmpty()) {
            builder.append(String.format("%nSearched in the following locations:", new Object[0]));
            for (String location : locations) {
                builder.append(String.format("%n    %s", location.replace("%", "%%")));
            }
        }
        return builder.toString();
    }
}

