/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dynamicversions;

import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.dynamicversions.DefaultCachedModuleVersionList;
import org.gradle.api.internal.artifacts.ivyservice.dynamicversions.ModuleVersionsCache;
import org.gradle.api.internal.artifacts.ivyservice.dynamicversions.ModuleVersionsCacheEntry;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.DefaultModuleVersionListing;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleVersionListing;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.Versioned;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.Serializer;
import org.gradle.util.BuildCommencedTimeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleFileBackedModuleVersionsCache
implements ModuleVersionsCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleFileBackedModuleVersionsCache.class);
    private final BuildCommencedTimeProvider timeProvider;
    private final CacheLockingManager cacheLockingManager;
    private PersistentIndexedCache<ModuleKey, ModuleVersionsCacheEntry> cache;

    public SingleFileBackedModuleVersionsCache(BuildCommencedTimeProvider timeProvider, CacheLockingManager cacheLockingManager) {
        this.timeProvider = timeProvider;
        this.cacheLockingManager = cacheLockingManager;
    }

    private PersistentIndexedCache<ModuleKey, ModuleVersionsCacheEntry> getCache() {
        if (this.cache == null) {
            this.cache = this.initCache();
        }
        return this.cache;
    }

    private PersistentIndexedCache<ModuleKey, ModuleVersionsCacheEntry> initCache() {
        return this.cacheLockingManager.createCache("module-versions", new ModuleKeySerializer(), new ModuleVersionsCacheEntrySerializer());
    }

    @Override
    public void cacheModuleVersionList(ModuleComponentRepository repository, ModuleIdentifier moduleId, ModuleVersionListing listedVersions) {
        LOGGER.debug("Caching version list in module versions cache: Using '{}' for '{}'", (Object)listedVersions, (Object)moduleId);
        this.getCache().put((Object)this.createKey(repository, moduleId), (Object)this.createEntry(listedVersions));
    }

    @Override
    public ModuleVersionsCache.CachedModuleVersionList getCachedModuleResolution(ModuleComponentRepository repository, ModuleIdentifier moduleId) {
        ModuleVersionsCacheEntry moduleVersionsCacheEntry = (ModuleVersionsCacheEntry)this.getCache().get((Object)this.createKey(repository, moduleId));
        if (moduleVersionsCacheEntry == null) {
            return null;
        }
        return new DefaultCachedModuleVersionList(moduleVersionsCacheEntry, this.timeProvider);
    }

    private ModuleKey createKey(ModuleComponentRepository repository, ModuleIdentifier moduleId) {
        return new ModuleKey(repository.getId(), moduleId);
    }

    private ModuleVersionsCacheEntry createEntry(ModuleVersionListing listedVersions) {
        return new ModuleVersionsCacheEntry(listedVersions, this.timeProvider.getCurrentTime());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModuleVersionsCacheEntrySerializer
    implements Serializer<ModuleVersionsCacheEntry> {
        private ModuleVersionsCacheEntrySerializer() {
        }

        public void write(Encoder encoder, ModuleVersionsCacheEntry value) throws Exception {
            Set<Versioned> versions = value.moduleVersionListing.getVersions();
            encoder.writeInt(versions.size());
            for (Versioned version : versions) {
                encoder.writeString((CharSequence)version.getVersion());
            }
            encoder.writeLong(value.createTimestamp);
        }

        public ModuleVersionsCacheEntry read(Decoder decoder) throws Exception {
            int size = decoder.readInt();
            DefaultModuleVersionListing versions = new DefaultModuleVersionListing();
            for (int i = 0; i < size; ++i) {
                versions.add(decoder.readString());
            }
            long createTimestamp = decoder.readLong();
            return new ModuleVersionsCacheEntry(versions, createTimestamp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModuleKeySerializer
    implements Serializer<ModuleKey> {
        private ModuleKeySerializer() {
        }

        public void write(Encoder encoder, ModuleKey value) throws Exception {
            encoder.writeString((CharSequence)value.repositoryId);
            encoder.writeString((CharSequence)value.moduleId.getGroup());
            encoder.writeString((CharSequence)value.moduleId.getName());
        }

        public ModuleKey read(Decoder decoder) throws Exception {
            String resolverId = decoder.readString();
            String group = decoder.readString();
            String module = decoder.readString();
            return new ModuleKey(resolverId, new DefaultModuleIdentifier(group, module));
        }
    }

    private static class ModuleKey {
        private final String repositoryId;
        private final ModuleIdentifier moduleId;

        private ModuleKey(String repositoryId, ModuleIdentifier moduleId) {
            this.repositoryId = repositoryId;
            this.moduleId = moduleId;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ModuleKey)) {
                return false;
            }
            ModuleKey other = (ModuleKey)o;
            return this.repositoryId.equals(other.repositoryId) && this.moduleId.equals(other.moduleId);
        }

        public int hashCode() {
            return this.repositoryId.hashCode() ^ this.moduleId.hashCode();
        }
    }
}

