/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.DependencyResolveDetailsInternal;
import org.gradle.api.internal.artifacts.ivyservice.ComponentResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.DefaultDependencyResolveDetails;
import org.gradle.api.internal.artifacts.ivyservice.DependencyToModuleVersionIdResolver;
import org.gradle.api.internal.artifacts.ivyservice.ModuleVersionIdResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ModuleVersionResolveException;
import org.gradle.api.internal.artifacts.ivyservice.SubstitutedModuleVersionIdResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.api.internal.artifacts.metadata.DependencyMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionForcingDependencyToModuleResolver
implements DependencyToModuleVersionIdResolver {
    private final DependencyToModuleVersionIdResolver resolver;
    private Action<DependencyResolveDetailsInternal> rule;

    public VersionForcingDependencyToModuleResolver(DependencyToModuleVersionIdResolver resolver, Action<DependencyResolveDetailsInternal> rule) {
        this.resolver = resolver;
        this.rule = rule;
    }

    @Override
    public ModuleVersionIdResolveResult resolve(DependencyMetaData dependency) {
        ModuleVersionSelector module = dependency.getRequested();
        DefaultDependencyResolveDetails details = new DefaultDependencyResolveDetails(module);
        try {
            this.rule.execute((Object)details);
        }
        catch (Throwable e) {
            return new FailedDependencyResolveRuleResult(module, e);
        }
        if (details.isUpdated()) {
            DependencyMetaData substitutedDependency = dependency.withRequestedVersion(details.getTarget());
            ModuleVersionIdResolveResult result = this.resolver.resolve(substitutedDependency);
            return new SubstitutedModuleVersionIdResolveResult(result, details.getSelectionReason(), details.getPreferredTarget());
        }
        return this.resolver.resolve(dependency);
    }

    private class FailedDependencyResolveRuleResult
    implements ModuleVersionIdResolveResult {
        private final ModuleVersionResolveException failure;

        public FailedDependencyResolveRuleResult(ModuleVersionSelector module, Throwable problem) {
            this.failure = new ModuleVersionResolveException(module, problem);
        }

        public ModuleVersionResolveException getFailure() {
            return this.failure;
        }

        public ModuleVersionIdentifier getId() throws ModuleVersionResolveException {
            throw this.failure;
        }

        public ComponentResolveResult resolve() throws ModuleVersionResolveException {
            throw this.failure;
        }

        public ComponentSelectionReason getSelectionReason() {
            return VersionSelectionReasons.REQUESTED;
        }

        public ModuleIdentifier getPreferredTarget() {
            return null;
        }
    }
}

