/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.exceptions.AbstractMultiCauseException;
import org.gradle.internal.exceptions.Contextual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Contextual
public class ModuleVersionResolveException
extends AbstractMultiCauseException {
    private final List<List<ModuleVersionIdentifier>> paths = new ArrayList<List<ModuleVersionIdentifier>>();
    private final String messageFormat;
    private final ModuleVersionSelector selector;

    public ModuleVersionResolveException(ModuleVersionSelector selector, String messageFormat) {
        super(ModuleVersionResolveException.format(messageFormat, selector));
        this.selector = selector;
        this.messageFormat = messageFormat;
    }

    public ModuleVersionResolveException(ModuleVersionIdentifier id, String messageFormat) {
        this(DefaultModuleVersionSelector.newSelector(id.getGroup(), id.getName(), id.getVersion()), messageFormat);
    }

    public ModuleVersionResolveException(ModuleComponentIdentifier id, String messageFormat) {
        this(DefaultModuleVersionSelector.newSelector(id.getGroup(), id.getModule(), id.getVersion()), messageFormat);
    }

    public ModuleVersionResolveException(ModuleVersionSelector selector, Throwable cause) {
        this(selector, "Could not resolve %s.");
        this.initCause(cause);
    }

    public ModuleVersionResolveException(ModuleVersionSelector selector, Iterable<? extends Throwable> causes) {
        this(selector, "Could not resolve %s.");
        this.initCauses(causes);
    }

    public ModuleVersionSelector getSelector() {
        return this.selector;
    }

    private static String format(String messageFormat, ModuleVersionSelector id) {
        return ModuleVersionResolveException.format(messageFormat, id.getGroup(), id.getName(), id.getVersion());
    }

    private static String format(String messageFormat, String group, String name, String version) {
        return String.format(messageFormat, String.format("%s:%s:%s", group, name, version));
    }

    public ModuleVersionResolveException withIncomingPaths(Collection<? extends List<ModuleVersionIdentifier>> paths) {
        ModuleVersionResolveException copy = this.createCopy();
        copy.paths.addAll(paths);
        copy.initCauses(this.getCauses());
        copy.setStackTrace(this.getStackTrace());
        return copy;
    }

    public String getMessage() {
        if (this.paths.isEmpty()) {
            return super.getMessage();
        }
        Formatter formatter = new Formatter();
        formatter.format("%s%nRequired by:", super.getMessage());
        for (List<ModuleVersionIdentifier> path : this.paths) {
            formatter.format("%n    %s", this.toString(path.get(0)));
            for (int i = 1; i < path.size(); ++i) {
                formatter.format(" > %s", this.toString(path.get(i)));
            }
        }
        return formatter.toString();
    }

    private String toString(ModuleVersionIdentifier identifier) {
        return identifier.toString();
    }

    protected ModuleVersionResolveException createCopy() {
        try {
            return (ModuleVersionResolveException)((Object)((Object)((Object)this)).getClass().getConstructor(ModuleVersionSelector.class, String.class).newInstance(this.selector, this.messageFormat));
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

