/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import groovy.lang.Closure;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.ArtifactDependencyResolver;
import org.gradle.api.internal.artifacts.ModuleMetadataProcessor;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorHandlingArtifactDependencyResolver
implements ArtifactDependencyResolver {
    private final ArtifactDependencyResolver dependencyResolver;

    public ErrorHandlingArtifactDependencyResolver(ArtifactDependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
    }

    @Override
    public void resolve(ConfigurationInternal configuration, List<? extends ResolutionAwareRepository> repositories, ModuleMetadataProcessor metadataProcessor, ResolverResults results) throws ResolveException {
        try {
            this.dependencyResolver.resolve(configuration, repositories, metadataProcessor, results);
        }
        catch (Throwable e) {
            results.failed(new BrokenResolvedConfiguration(e, (Configuration)configuration), ErrorHandlingArtifactDependencyResolver.wrapException(e, (Configuration)configuration));
            return;
        }
        ErrorHandlingResolvedConfiguration wrappedConfiguration = new ErrorHandlingResolvedConfiguration(results.getResolvedConfiguration(), (Configuration)configuration);
        ErrorHandlingResolutionResult wrappedResult = new ErrorHandlingResolutionResult(results.getResolutionResult(), (Configuration)configuration);
        results.resolved(wrappedConfiguration, wrappedResult);
    }

    private static ResolveException wrapException(Throwable e, Configuration configuration) {
        if (e instanceof ResolveException) {
            return (ResolveException)e;
        }
        return new ResolveException(configuration, e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BrokenResolvedConfiguration
    implements ResolvedConfiguration {
        private final Throwable e;
        private final Configuration configuration;

        public BrokenResolvedConfiguration(Throwable e, Configuration configuration) {
            this.e = e;
            this.configuration = configuration;
        }

        public boolean hasError() {
            return true;
        }

        public LenientConfiguration getLenientConfiguration() {
            throw ErrorHandlingArtifactDependencyResolver.wrapException(this.e, this.configuration);
        }

        public void rethrowFailure() throws ResolveException {
            throw ErrorHandlingArtifactDependencyResolver.wrapException(this.e, this.configuration);
        }

        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) throws ResolveException {
            throw ErrorHandlingArtifactDependencyResolver.wrapException(this.e, this.configuration);
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies() throws ResolveException {
            throw ErrorHandlingArtifactDependencyResolver.wrapException(this.e, this.configuration);
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) throws ResolveException {
            throw ErrorHandlingArtifactDependencyResolver.wrapException(this.e, this.configuration);
        }

        public Set<ResolvedArtifact> getResolvedArtifacts() throws ResolveException {
            throw ErrorHandlingArtifactDependencyResolver.wrapException(this.e, this.configuration);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorHandlingResolvedConfiguration
    implements ResolvedConfiguration {
        private final ResolvedConfiguration resolvedConfiguration;
        private final Configuration configuration;

        public ErrorHandlingResolvedConfiguration(ResolvedConfiguration resolvedConfiguration, Configuration configuration) {
            this.resolvedConfiguration = resolvedConfiguration;
            this.configuration = configuration;
        }

        public boolean hasError() {
            return this.resolvedConfiguration.hasError();
        }

        public LenientConfiguration getLenientConfiguration() {
            try {
                return new ErrorHandlingLenientConfiguration(this.resolvedConfiguration.getLenientConfiguration(), this.configuration);
            }
            catch (Throwable e) {
                throw ErrorHandlingArtifactDependencyResolver.wrapException(e, this.configuration);
            }
        }

        public void rethrowFailure() throws ResolveException {
            try {
                this.resolvedConfiguration.rethrowFailure();
            }
            catch (Throwable e) {
                throw ErrorHandlingArtifactDependencyResolver.wrapException(e, this.configuration);
            }
        }

        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) throws ResolveException {
            try {
                return this.resolvedConfiguration.getFiles(dependencySpec);
            }
            catch (Throwable e) {
                throw ErrorHandlingArtifactDependencyResolver.wrapException(e, this.configuration);
            }
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies() throws ResolveException {
            try {
                return this.resolvedConfiguration.getFirstLevelModuleDependencies();
            }
            catch (Throwable e) {
                throw ErrorHandlingArtifactDependencyResolver.wrapException(e, this.configuration);
            }
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) throws ResolveException {
            try {
                return this.resolvedConfiguration.getFirstLevelModuleDependencies(dependencySpec);
            }
            catch (Throwable e) {
                throw ErrorHandlingArtifactDependencyResolver.wrapException(e, this.configuration);
            }
        }

        public Set<ResolvedArtifact> getResolvedArtifacts() throws ResolveException {
            try {
                return this.resolvedConfiguration.getResolvedArtifacts();
            }
            catch (Throwable e) {
                throw ErrorHandlingArtifactDependencyResolver.wrapException(e, this.configuration);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorHandlingResolutionResult
    implements ResolutionResult {
        private final ResolutionResult resolutionResult;
        private final Configuration configuration;

        public ErrorHandlingResolutionResult(ResolutionResult resolutionResult, Configuration configuration) {
            this.resolutionResult = resolutionResult;
            this.configuration = configuration;
        }

        public ResolvedComponentResult getRoot() {
            try {
                return this.resolutionResult.getRoot();
            }
            catch (Throwable e) {
                throw ErrorHandlingArtifactDependencyResolver.wrapException(e, this.configuration);
            }
        }

        public void allDependencies(Action<? super DependencyResult> action) {
            this.resolutionResult.allDependencies(action);
        }

        public Set<? extends DependencyResult> getAllDependencies() {
            try {
                return this.resolutionResult.getAllDependencies();
            }
            catch (Throwable e) {
                throw ErrorHandlingArtifactDependencyResolver.wrapException(e, this.configuration);
            }
        }

        public void allDependencies(Closure closure) {
            this.resolutionResult.allDependencies(closure);
        }

        public Set<ResolvedComponentResult> getAllComponents() {
            try {
                return this.resolutionResult.getAllComponents();
            }
            catch (Throwable e) {
                throw ErrorHandlingArtifactDependencyResolver.wrapException(e, this.configuration);
            }
        }

        public void allComponents(Action<? super ResolvedComponentResult> action) {
            this.resolutionResult.allComponents(action);
        }

        public void allComponents(Closure closure) {
            this.resolutionResult.allComponents(closure);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorHandlingLenientConfiguration
    implements LenientConfiguration {
        private final LenientConfiguration lenientConfiguration;
        private final Configuration configuration;

        private ErrorHandlingLenientConfiguration(LenientConfiguration lenientConfiguration, Configuration configuration) {
            this.lenientConfiguration = lenientConfiguration;
            this.configuration = configuration;
        }

        public Set<ResolvedArtifact> getArtifacts(Spec<? super Dependency> dependencySpec) {
            try {
                return this.lenientConfiguration.getArtifacts(dependencySpec);
            }
            catch (Throwable e) {
                throw ErrorHandlingArtifactDependencyResolver.wrapException(e, this.configuration);
            }
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) {
            try {
                return this.lenientConfiguration.getFirstLevelModuleDependencies(dependencySpec);
            }
            catch (Throwable e) {
                throw ErrorHandlingArtifactDependencyResolver.wrapException(e, this.configuration);
            }
        }

        public Set<UnresolvedDependency> getUnresolvedModuleDependencies() {
            try {
                return this.lenientConfiguration.getUnresolvedModuleDependencies();
            }
            catch (Throwable e) {
                throw ErrorHandlingArtifactDependencyResolver.wrapException(e, this.configuration);
            }
        }

        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) {
            try {
                return this.lenientConfiguration.getFiles(dependencySpec);
            }
            catch (Throwable e) {
                throw ErrorHandlingArtifactDependencyResolver.wrapException(e, this.configuration);
            }
        }
    }
}

