/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ArtifactResolveException;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedConfigurationResults;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Factory;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraphWithEdgeValues;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLenientConfiguration
implements LenientConfiguration {
    private CacheLockingManager cacheLockingManager;
    private final Configuration configuration;
    private ResolvedConfigurationResults results;

    public DefaultLenientConfiguration(Configuration configuration, ResolvedConfigurationResults results, CacheLockingManager cacheLockingManager) {
        this.configuration = configuration;
        this.results = results;
        this.cacheLockingManager = cacheLockingManager;
    }

    public boolean hasError() {
        return this.results.hasError();
    }

    public void rethrowFailure() throws ResolveException {
        if (this.hasError()) {
            ArrayList<Throwable> failures = new ArrayList<Throwable>();
            for (UnresolvedDependency unresolvedDependency : this.results.getUnresolvedDependencies()) {
                failures.add(unresolvedDependency.getProblem());
            }
            throw new ResolveException(this.configuration, failures);
        }
    }

    public Set<UnresolvedDependency> getUnresolvedModuleDependencies() {
        return this.results.getUnresolvedDependencies();
    }

    public Set<ResolvedArtifact> getResolvedArtifacts() throws ResolveException {
        return this.results.getArtifacts();
    }

    public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) {
        LinkedHashSet<ResolvedDependency> matches = new LinkedHashSet<ResolvedDependency>();
        for (Map.Entry<ModuleDependency, ResolvedDependency> entry : this.results.more().getFirstLevelDependencies().entrySet()) {
            if (!dependencySpec.isSatisfiedBy((Object)entry.getKey())) continue;
            matches.add(entry.getValue());
        }
        return matches;
    }

    public Set<File> getFiles(Spec<? super Dependency> dependencySpec) {
        Set<ResolvedArtifact> artifacts = this.getArtifacts(dependencySpec);
        return this.getFiles(artifacts);
    }

    public Set<File> getFilesStrict(Spec<? super Dependency> dependencySpec) {
        Set<ResolvedArtifact> artifacts = this.getAllArtifacts(dependencySpec);
        return this.getFiles(artifacts);
    }

    public Set<ResolvedArtifact> getArtifacts(Spec<? super Dependency> dependencySpec) {
        final Set<ResolvedArtifact> allArtifacts = this.getAllArtifacts(dependencySpec);
        return (Set)this.cacheLockingManager.useCache("retrieve artifacts from " + this.configuration, (Factory)new Factory<Set<ResolvedArtifact>>(){

            public Set<ResolvedArtifact> create() {
                return CollectionUtils.filter((Set)allArtifacts, (Spec)new Spec<ResolvedArtifact>(){

                    public boolean isSatisfiedBy(ResolvedArtifact element) {
                        try {
                            File file = element.getFile();
                            return file != null;
                        }
                        catch (ArtifactResolveException e) {
                            return false;
                        }
                    }
                });
            }
        });
    }

    private Set<File> getFiles(final Set<ResolvedArtifact> artifacts) {
        final LinkedHashSet<File> files = new LinkedHashSet<File>();
        this.cacheLockingManager.useCache("resolve files from " + this.configuration, new Runnable(){

            public void run() {
                for (ResolvedArtifact artifact : artifacts) {
                    File depFile = artifact.getFile();
                    if (depFile == null) continue;
                    files.add(depFile);
                }
            }
        });
        return files;
    }

    public Set<ResolvedArtifact> getAllArtifacts(Spec<? super Dependency> dependencySpec) {
        if (dependencySpec == Specs.SATISFIES_ALL) {
            return this.results.getArtifacts();
        }
        CachingDirectedGraphWalker walker = new CachingDirectedGraphWalker((DirectedGraphWithEdgeValues)new ResolvedDependencyArtifactsGraph());
        Set<ResolvedDependency> firstLevelModuleDependencies = this.getFirstLevelModuleDependencies(dependencySpec);
        LinkedHashSet<ResolvedArtifact> artifacts = new LinkedHashSet<ResolvedArtifact>();
        for (ResolvedDependency resolvedDependency : firstLevelModuleDependencies) {
            artifacts.addAll(resolvedDependency.getParentArtifacts(this.results.more().getRoot()));
            walker.add((Object[])new ResolvedDependency[]{resolvedDependency});
        }
        artifacts.addAll(walker.findValues());
        return artifacts;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Set<ResolvedDependency> getFirstLevelModuleDependencies() {
        return this.results.more().getRoot().getChildren();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolvedDependencyArtifactsGraph
    implements DirectedGraphWithEdgeValues<ResolvedDependency, ResolvedArtifact> {
        private ResolvedDependencyArtifactsGraph() {
        }

        public void getNodeValues(ResolvedDependency node, Collection<? super ResolvedArtifact> values, Collection<? super ResolvedDependency> connectedNodes) {
            connectedNodes.addAll(node.getChildren());
        }

        public void getEdgeValues(ResolvedDependency from, ResolvedDependency to, Collection<ResolvedArtifact> values) {
            values.addAll(to.getParentArtifacts(from));
        }
    }
}

