/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.DependencyResolveDetailsInternal;
import org.gradle.api.internal.artifacts.dsl.ModuleVersionSelectorParsers;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;

public class DefaultDependencyResolveDetails
implements DependencyResolveDetailsInternal {
    private final ModuleVersionSelector requested;
    private ComponentSelectionReason selectionReason;
    private ModuleVersionSelector target;
    private ModuleIdentifier preferredTarget;

    public DefaultDependencyResolveDetails(ModuleVersionSelector requested) {
        this.requested = requested;
        this.target = requested;
    }

    public ModuleVersionSelector getRequested() {
        return this.requested;
    }

    public void useVersion(String version) {
        this.useVersion(version, VersionSelectionReasons.SELECTED_BY_RULE);
    }

    public void useVersion(String version, ComponentSelectionReason selectionReason) {
        assert (selectionReason != null);
        if (version == null) {
            throw new IllegalArgumentException("Configuring the dependency resolve details with 'null' version is not allowed.");
        }
        if (!version.equals(this.target.getVersion())) {
            this.target = DefaultModuleVersionSelector.newSelector(this.target.getGroup(), this.target.getName(), version);
        }
        this.selectionReason = selectionReason;
    }

    public void useTarget(Object notation) {
        this.target = (ModuleVersionSelector)ModuleVersionSelectorParsers.parser().parseNotation(notation);
        this.selectionReason = VersionSelectionReasons.SELECTED_BY_RULE;
    }

    public void prefer(Object notation) {
        this.selectionReason = VersionSelectionReasons.REQUESTED;
        String[] s = notation.toString().split(":");
        this.preferredTarget = new DefaultModuleIdentifier(s[0], s[1]);
    }

    public ComponentSelectionReason getSelectionReason() {
        return this.selectionReason;
    }

    public ModuleVersionSelector getTarget() {
        return this.target;
    }

    public boolean isUpdated() {
        return this.selectionReason != null;
    }

    public ModuleIdentifier getPreferredTarget() {
        return this.preferredTarget;
    }
}

