/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.artifacts.ivyservice.BuildableArtifactSetResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ArtifactResolveException;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildableArtifactSetResolveResult
implements BuildableArtifactSetResolveResult {
    private ArtifactResolveException failure;
    private Set<ComponentArtifactMetaData> artifacts;

    @Override
    public void resolved(Collection<? extends ComponentArtifactMetaData> artifacts) {
        this.artifacts = new LinkedHashSet<ComponentArtifactMetaData>(artifacts);
    }

    @Override
    public void failed(ArtifactResolveException failure) {
        this.failure = failure;
    }

    @Override
    public boolean hasResult() {
        return this.artifacts != null || this.failure != null;
    }

    @Override
    public ArtifactResolveException getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    @Override
    public Set<ComponentArtifactMetaData> getArtifacts() {
        this.assertResolved();
        return this.artifacts;
    }

    private void assertResolved() {
        this.assertHasResult();
        if (this.failure != null) {
            throw this.failure;
        }
    }

    private void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }
}

