/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import org.gradle.api.internal.artifacts.ivyservice.BuildableArtifactResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.DefaultResourceAwareResolveResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ArtifactNotFoundException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ArtifactResolveException;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactIdentifier;

public class DefaultBuildableArtifactResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableArtifactResolveResult {
    private ArtifactResolveException failure;
    private File file;

    public void failed(ArtifactResolveException failure) {
        this.failure = failure;
    }

    public void resolved(File file) {
        this.file = file;
    }

    public void notFound(ComponentArtifactIdentifier artifact) {
        this.failed(new ArtifactNotFoundException(artifact, this.getAttempted()));
    }

    public ArtifactResolveException getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    public File getFile() throws ArtifactResolveException {
        this.assertResolved();
        return this.file;
    }

    public boolean hasResult() {
        return this.failure != null || this.file != null;
    }

    private void assertResolved() {
        this.assertHasResult();
        if (this.failure != null) {
            throw this.failure;
        }
    }

    private void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }
}

