/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.util.Collection;
import java.util.Set;
import org.gradle.api.IllegalDependencyNotation;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.dsl.ParsedModuleStringNotation;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationParser;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleVersionSelectorParsers {
    public static NotationParser<Object, Set<ModuleVersionSelector>> multiParser() {
        return ModuleVersionSelectorParsers.builder().toFlatteningComposite();
    }

    public static NotationParser<Object, ModuleVersionSelector> parser() {
        return ModuleVersionSelectorParsers.builder().toComposite();
    }

    private static NotationParserBuilder<ModuleVersionSelector> builder() {
        return NotationParserBuilder.toType(ModuleVersionSelector.class).fromCharSequence((NotationConverter)new StringParser()).parser((NotationParser)new MapParser());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringParser
    implements NotationConverter<String, ModuleVersionSelector> {
        StringParser() {
        }

        public void describe(Collection<String> candidateFormats) {
            candidateFormats.add("String or CharSequence values, e.g. 'org.gradle:gradle-core:1.0'.");
        }

        public void convert(String notation, NotationConvertResult<? super ModuleVersionSelector> result) throws TypeConversionException {
            ParsedModuleStringNotation parsed;
            try {
                parsed = new ParsedModuleStringNotation(notation, null);
            }
            catch (IllegalDependencyNotation e) {
                throw new InvalidUserDataException("Invalid format: '" + notation + "'. The correct notation is a 3-part group:name:version notation, " + "e.g: 'org.gradle:gradle-core:1.0'");
            }
            if (parsed.getGroup() == null || parsed.getName() == null || parsed.getVersion() == null) {
                throw new InvalidUserDataException("Invalid format: '" + notation + "'. Group, name and version cannot be empty. Correct example: " + "'org.gradle:gradle-core:1.0'");
            }
            result.converted((Object)DefaultModuleVersionSelector.newSelector(parsed.getGroup(), parsed.getName(), parsed.getVersion()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapParser
    extends MapNotationParser<ModuleVersionSelector> {
        MapParser() {
        }

        public void describe(Collection<String> candidateFormats) {
            candidateFormats.add("Maps, e.g. [group: 'org.gradle', name:'gradle-core', version: '1.0'].");
        }

        protected ModuleVersionSelector parseMap(@MapKey(value="group") String group, @MapKey(value="name") String name, @MapKey(value="version") String version) {
            return DefaultModuleVersionSelector.newSelector(group, name, version);
        }
    }
}

