/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.dsl.ComponentMetadataHandler;
import org.gradle.api.artifacts.ivy.IvyModuleDescriptor;
import org.gradle.api.internal.artifacts.ModuleMetadataProcessor;
import org.gradle.api.internal.artifacts.ivyservice.DefaultIvyModuleDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.ModuleVersionResolveException;
import org.gradle.api.internal.artifacts.metadata.IvyModuleVersionMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionMetaData;
import org.gradle.api.internal.artifacts.repositories.resolver.ComponentMetadataDetailsAdapter;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.listener.ActionBroadcast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComponentMetadataHandler
implements ComponentMetadataHandler,
ModuleMetadataProcessor {
    private final Instantiator instantiator;
    private final ActionBroadcast<ComponentMetadataDetails> ruleActions = new ActionBroadcast();
    private final List<Closure<?>> ruleClosures = Lists.newArrayList();

    public DefaultComponentMetadataHandler(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public void eachComponent(Action<? super ComponentMetadataDetails> rule) {
        this.ruleActions.add(rule);
    }

    public void eachComponent(Closure<?> closure) {
        this.ruleClosures.add(closure);
    }

    @Override
    public void process(ModuleVersionMetaData metadata) {
        ComponentMetadataDetails details = (ComponentMetadataDetails)this.instantiator.newInstance(ComponentMetadataDetailsAdapter.class, new Object[]{metadata});
        this.ruleActions.execute((Object)details);
        this.executeRuleClosures(metadata, details);
        if (!metadata.getStatusScheme().contains(metadata.getStatus())) {
            throw new ModuleVersionResolveException(metadata.getId(), "Unexpected status '" + metadata.getStatus() + "' specified for %s. Expected one of: " + metadata.getStatusScheme());
        }
    }

    private void executeRuleClosures(ModuleVersionMetaData metadata, ComponentMetadataDetails details) {
        for (Closure<?> closure : this.ruleClosures) {
            this.executeRuleClosure(metadata, details, closure);
        }
    }

    private void executeRuleClosure(ModuleVersionMetaData metadata, ComponentMetadataDetails details, Closure<?> closure) {
        Class[] parameterTypes = closure.getParameterTypes();
        if (parameterTypes.length == 0) {
            throw new InvalidUserCodeException("A component metadata rule needs to have at least one parameter.");
        }
        ArrayList args = Lists.newArrayList();
        if (!parameterTypes[0].isAssignableFrom(ComponentMetadataDetails.class)) {
            throw new InvalidUserCodeException(String.format("First parameter of a component metadata rule needs to be of type '%s'.", ComponentMetadataDetails.class.getSimpleName()));
        }
        args.add(details);
        for (Class parameterType : Arrays.asList(parameterTypes).subList(1, parameterTypes.length)) {
            if (parameterType == IvyModuleDescriptor.class) {
                if (!(metadata instanceof IvyModuleVersionMetaData)) {
                    return;
                }
                IvyModuleVersionMetaData ivyMetadata = (IvyModuleVersionMetaData)metadata;
                args.add(new DefaultIvyModuleDescriptor(ivyMetadata.getExtraInfo(), ivyMetadata.getBranch(), ivyMetadata.getStatus()));
                continue;
            }
            throw new InvalidUserCodeException(String.format("Unsupported parameter type for component metadata rule: %s", parameterType.getName()));
        }
        closure.call(args.toArray());
    }
}

